#!/bin/bash

# File with format: <last_update_ts>,<ooms>
COUNTER='/tmp/tmp-oom-checker-ts-counter'

die () {
    echo "$1;$2"
    exit 0
}

while getopts "h:" OPTION
do
    case $OPTION in
        h)
            WARN_HOURS="$OPTARG"
        ;;
    esac
done

# Light warning for the specified period of time
warn_hours=${WARN_HOURS:-24}
warn_seconds=$((warn_hours * 60 * 60))

if [ -f /usr/local/sbin/autodetect_environment ] ; then
    is_virtual_host=0
    . /usr/local/sbin/autodetect_environment >/dev/null 2>&1 || true
    if [ "$is_virtual_host" -eq 1 ] ; then
        die 0 "OK"
    fi
fi

if [ ! -f /proc/vmstat ]; then
    die 0 "OK"
fi

ooms=$(awk '/oom_kill/{print $2}' /proc/vmstat)
ooms=${ooms:-0}
curr_ts=$(date +%s)

# Initialize counter if not present
if [ ! -f $COUNTER ]; then
    echo "$curr_ts,$ooms" > "$COUNTER"
fi

last_ts=$(cut -f 1 -d ',' $COUNTER)
last_value=$(cut -f 2 -d ',' $COUNTER)
new_ooms=$((ooms - last_value))
last_update=$((curr_ts - last_ts))

# Update counter ts if new OOMs occurred
if [ $new_ooms -gt 0 ]; then
    echo "$curr_ts,$ooms" > "$COUNTER"
    die 1 "$ooms oom_kills"
fi

if [ $warn_seconds -gt $last_update -a $ooms -gt 0 ]; then
    die 1 "$ooms oom_kills"
fi

die 0 "OK"
