#!/bin/sh

die () {
    message=$2
    if [ -z "$message" ]; then
        message="OK"
    fi
    echo "$1;$message"
    exit 0
}

reserved_blocks_promille_limit=${1:-45}
message=""
status=0
reserved_pattern='Reserved block count:'
total_pattern='Block count:'

if [ -f /usr/local/sbin/autodetect_environment ] ; then
    is_virtual_host=0
    . /usr/local/sbin/autodetect_environment >/dev/null 2>&1 || true
    if [ "$is_virtual_host" -eq 1 ] ; then
        die 0 "OK"
    fi
fi

if grep 'model name' /proc/cpuinfo | grep -q 'KVM'
then
    die 0 "OK"
elif sudo grep /var/log/dmesg -e 'Booting paravirtualized kernel on KVM' -q 2>/dev/null
then
    die 0 "OK"
fi

for device in $(sudo df -P -l -k -t ext2 -t ext3 -t ext4 -t xfs -t simfs | grep / | awk '{print $1}'); do
    fsinfo=$(sudo dumpe2fs -h $device 2>/dev/null | grep -e "$reserved_pattern" -e "$total_pattern")
    reserved_blocks=$(echo "$fsinfo" | grep "$reserved_pattern" | awk '{print $NF}')
    total_blocks=$(echo "$fsinfo" | grep "$total_pattern" | awk '{print $NF}')
    reserved_blocks_promille=$(( reserved_blocks * 1000 / total_blocks ))
    if [ $reserved_blocks_promille -le $reserved_blocks_promille_limit ]; then
        message="${message}$device=$(echo $reserved_blocks_promille | sed 's/.$/.&/')% "
        status=2
    fi
done

die $status "$message"
