#!/bin/bash

me=${0##*/}     # strip path
me=${me%.*}     # strip extension
lock="/tmp/${me}.lock"

die () {
    echo "$1;$2"
    exit 0
}

exec 200>"$lock" 2>&1
flock -n 200 >/dev/null 2>&1 || die 1 "Unable to get lock"
echo $$ >&200

DIFFS="$(sudo /usr/bin/timeout 480 /usr/bin/salt-call state.highstate test=True -l quiet queue=True --output=yaml 2>&1)"
RESULT=$?
NUM_DIFFS="$(printf '%s' "$DIFFS" | { grep -E '^\ *result:' | grep -cv true || true; })"
NUM_STATES="$(printf '%s' "$DIFFS" | { grep -c -E '^\ *result:' || true; })"

rm -f "$lock"

if [ "$RESULT" != "0" ]
then
    die 1 "Salt-call failed"
fi

if [ "$NUM_STATES" = "0" ]
then
    die 2 "Service is dead"
fi

if [ "$NUM_DIFFS" = "0" ]
then
    die 0 "OK"
else
    die 1 "Highstate is outdated, $NUM_DIFFS diffs"
fi
