#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
Check if yasm aggregators are getting data from local yasmagent
"""

from __future__ import absolute_import, print_function, unicode_literals

import os
import sys
import time

import requests


def die(status=0, message='OK'):
    """
    Print status;message and exit
    """
    print('%s;%s' % (status, message))
    sys.exit(0)


def _main():
    if not os.path.exists('/etc/init.d/yasmagent'):
        die()

    try:
        ping_ts = requests.get('http://localhost:11003/ping')
        if ping_ts.status_code != 200 or not ping_ts.text:
            die(2, 'Ping failed')

        delta = int(time.time()) - int(ping_ts.text)
        if delta > 5:
            die(1, 'Ping old timestamp: %s' % ping_ts.text)
        else:
            die()
    except Exception as exc:
        die(1, 'Unable to check: %s' % repr(exc))


if __name__ == '__main__':
    _main()
