include:
    - components.monrun2

monrun-disk-scripts:
    file.recurse:
        - name: /usr/local/yandex/monitoring
        - file_mode: '0755'
        - template: jinja
        - source: salt://{{ slspath }}/scripts
        - include_empty: True
        - watch_in:
            - cmd: monrun-jobs-update

monrun-disk-confs:
    file.recurse:
        - name: /etc/monrun/conf.d
        - file_mode: '0644'
        - template: jinja
        - source: salt://{{ slspath }}/conf.d
        - include_empty: True
        - watch_in:
            - cmd: monrun-jobs-update

monrun-disk-sudoers:
    file.recurse:
        - name: /etc/sudoers.d
        - file_mode: '0440'
        - template: jinja
        - source: salt://{{ slspath }}/sudoers.d
        - include_empty: True
        - watch_in:
            - cmd: monrun-jobs-update

monrun-disk-packages:
    pkg.installed:
        - pkgs:
            - config-monrun-mtu-check: 0.12
            - config-autodetect-active-eth: 1.0-41
