#!/bin/sh
#
# Provides: xscript_errors 

me=${0##*/}     # strip path
me=${me%.*}     # strip extension
LOG="/var/log/syslog"

die () {
        echo "PASSIVE-CHECK:$me;$1;$2"
        exit 0
}

Q=`sudo /usr/bin/timetail -n 60 -t syslog $LOG | fgrep xscript | egrep -c "fetchAuthUID:|Http\ timeout\ error|Timeout\ was\ reached|Bad UA|Bad referer|server responded|error type=|No UA and Cookies|Couldn't connect to server"`
if [ "x$Q" == "x" ]; then $Q=0; fi

die 0 $Q
