include:
  - .common
  - .service

yamail-monitor:
    pkg.purged:
        - require_in:
            - pkg: juggler-pgks

config-juggler-client-mail:
    pkg.purged:
        - require_in:
            - pkg: juggler-pgks

snaked:
    pkg.purged:
       - require_in:
            - pkg: juggler-pgks

yamail-monrun:
    pkg.purged:
       - require_in:
            - pkg: juggler-pgks

yamail-monrun-common:
    pkg.purged:
       - require_in:
            - pkg: juggler-pgks

juggler-client-purge:
    pkg.purged:
       - version: '1.4.53'
       - require_in:
            - pkg: juggler-pgks

monrun-purge:
    pkg.purged:
       - version: '1.2.52-1+sleep.1'
       - require_in:
            - pkg: juggler-pgks

config-juggler-search:
    pkg.purged

yamail-monrun-errata:
    pkg.installed:
        - version: 37-bbc446c
        - require:
            - pkg: juggler-pgks
        - watch_in:
            - cmd: monrun-jobs-update

yamail-monrun-restart-required:
    pkg.installed:
        - version: '4-d10c615'
        - require:
            - pkg: juggler-pgks
        - watch_in:
            - cmd: monrun-jobs-update

yandex-media-common-grub-check:
    pkg.installed:
        - version: '0.5.5'
        - require:
            - pkg: juggler-pgks
        - watch_in:
            - cmd: monrun-jobs-update

grub-check-cron-remove:
    file.absent:
        - name: /etc/cron.hourly/grub_repair_by_grub-check
        - require:
            - pkg: yandex-media-common-grub-check

yandex-media-common-iface-ip-check:
    pkg.purged:
        - watch_in:
            - cmd: monrun-jobs-update

/etc/monrun/conf.d/iface_ip.conf:
    file.absent:
        - watch_in:
            - cmd: monrun-jobs-update

/var/log/juggler-client:
    file.directory:
        - user: monitor
        - group: monitor
        - recurse:
            - user
            - group
        - require:
            - pkg: juggler-pgks
        - watch_in:
            - cmd: juggler-client-restart

/var/log/monrun:
    file.directory:
        - user: monitor
        - group: monitor
        - recurse:
            - user
            - group
        - require:
            - pkg: juggler-pgks
        - watch_in:
            - cmd: juggler-client-restart

/etc/monrun/general.conf:
    file.managed:
        - source: salt://{{ slspath }}/config/general.conf
        - user: monitor
        - group: monitor
        - mode: 644
        - require:
            - pkg: juggler-pgks
        - watch_in:
            - cmd: juggler-client-restart

/etc/juggler/etc:
    file.directory:
        - user: root
        - group: root
        - mode: 755
        - require:
            - pkg: juggler-pgks
            - pkg: config-juggler-search

/etc/juggler/etc/client.conf:
    file.managed:
        - source: salt://{{ slspath }}/config/client.conf
        - user: root
        - group: root
        - mode: 644
        - require:
            - pkg: juggler-pgks
            - file: /etc/juggler/etc
        - watch_in:
            - cmd: juggler-client-restart

/etc/default/juggler-client:
    file.managed:
        - source: salt://{{ slspath }}/config/juggler-client
        - user: root
        - group: root
        - mode: 644
        - require:
            - pkg: juggler-pgks
            - pkg: config-juggler-search
        - watch_in:
            - cmd: juggler-client-restart
