#!/usr/bin/env python

import argparse
import sys
import re
import socket

import psycopg2

parser = argparse.ArgumentParser()

parser.add_argument('-c', '--check',
                    type=str,
                    help='check type')

args = parser.parse_args()

def die(code=0, comment="OK"):
    if code == 0:
        print("0;OK")
    else:
        print('%d;%s' % (code, comment))
    sys.exit(0)

try:
    conn = psycopg2.connect("dbname=maildb user=monitor connect_timeout=1")
    cur = conn.cursor()
    shard_name = re.match('[a-z0-9-]+[0-9]+', socket.gethostname()).group(0)

    cur.execute("SHOW transaction_read_only;")
    if 'on' in str(cur.fetchone()[0]):
        die(0, "OK")
    if args.check == 'worker_alive':
        query = """
                   SELECT count(1)
                    FROM mail.doberman_jobs
                   WHERE NOT code.is_system_worker(worker_id)
                   AND coalesce(heartbeated, '-infinity') < (now() - interval '90 seconds')
                """
    elif args.check == 'workerless_jobs':
         query = """
                  SELECT count(1) FROM (
                     SELECT *
                        FROM mail.shared_folder_subscriptions
                      WHERE worker_id IS NULL
                       AND code.is_operable_subscription(state)) free_subs
                        WHERE free_subs.created < (now() - interval '90 seconds')"""
    elif args.check == 'broken_subscription':
         query = """
                  SELECT count(1)
                   FROM mail.shared_folder_subscriptions
                  WHERE state IN ('init-fail', 'migrate-fail', 'sync-fail')"""

    cur.execute(query)

    count = cur.fetchone()[0]
    if count > 0:
        die(2, "%s has %d row in %s " % (shard_name, count, args.check))
    else:
        die(0, "OK")

except Exception as e:
    die(1, "Could not get info about doberman check: %s" % e)
