#!/usr/bin/python

import socket
import sys
import time
import urllib
import psycopg2
import argparse

parser = argparse.ArgumentParser()

parser.add_argument('-s', '--start',
                    type=str,
                    default='7 day',
                    help='Start interval')

parser.add_argument('-e', '--end',
                    type=str,
                    default='3 hour',
                    help='End interval')

args = parser.parse_args()

def die(code=0, comment='OK'):
    print('%d;%s' % (code, comment))

def get_master_from_group(group, dbname):
    m = urllib.urlopen('http://c.yandex-team.ru/api/groups2hosts/%s?fields='
                       'fqdn' % group ).readlines()
    master = None
    try:
        for host in m:
            conn = psycopg2.connect('host=%s port=6432 dbname=%s user=monitor '
                                    'connect_timeout=1' % \
                                    (host, dbname))
            cur = conn.cursor()
            cur.execute("SELECT master FROM repl_mon;")
            master = str(cur.fetchone()[0])
            cur.close()
            conn.close()
            if master:
                return master
    except Exception as err:
        print(err)
        pass

def main():
    master_host = get_master_from_group('mail_mopsdb', 'huskydb')
    conn_str = ('host=%s port=6432 dbname=huskydb user=monitor '
                        'connect_timeout=1') % \
                         (master_host)
    conn = psycopg2.connect(conn_str)
    cur = conn.cursor()
    sql=u"""SELECT count(1)
              FROM transfer.users_in_dogsleds
            WHERE task='clone_user'
              AND status NOT IN
                ('complete', 'pending', 'in_progress')
              AND last_update 
              BETWEEN now()-INTERVAL %(start)s
              AND now()-INTERVAL %(end)s
        """
    cur.execute(sql,{'start': args.start, 'end': args.end})
    if cur.fetchone()[0] == 0:
        die()
    else:
        die(1,'Has incomplete clone task')

if __name__ == '__main__':
    main()
