#!/bin/bash

die () {
    if [ "$1" = "0" ]; then
        msg="OK"
    else
        msg="$2"
    fi
    echo "$1;$msg"
    exit 0
}

die_code=0
die_msg=""

for server in $(sudo /usr/bin/barman list-server | awk '{print $1}'); do
    barman_check_out=$(sudo /usr/bin/timeout 10 /usr/bin/barman check $server 2>&1)
    exit_code=$?
    if [ "$exit_code" = "0" ]; then
        continue
    elif [ "$exit_code" = "1" ]; then
        msg=$(echo "$barman_check_out" | grep -v OK | grep -v 'failed backups' | sed -e ':a' -e 'N' -e '$!ba' -e 's/\n\t/ /g' | grep -v ':$' | sed -e ':a' -e 'N' -e '$!ba' -e 's/\n/\; /g')
        if [ "$msg" != "" ]; then
            die_code=1
            if [ "$die_msg" != "" ]; then
                append="; "
            fi
            die_msg="${die_msg}${append}${msg}"
        fi
    else
        die_code=1
        if [ "$die_msg" != "" ]; then
            append="; "
        fi
        die_msg="${die_msg}${append}${server} timed out"
    fi
done

die $die_code "$die_msg"
