#!/bin/bash

die () {
    echo "$1;$2"
    exit 0
}

while getopts "w:c:f:b:" OPTION
do
    case $OPTION in
        w)
            WARN_LIMIT="$OPTARG"
        ;;
        c)
            CRIT_LIMIT="$OPTARG"
        ;;
        f)
            STATUS_FILE="$OPTARG"
        ;;
        b)
            BARMAN_CONF="$OPTARG"
        ;;
    esac
done

status_file=${STATUS_FILE:-/tmp/check_xlogs.status}
warn_limit=${WARN_LIMIT:-7200}
crit_limit=${CRIT_LIMIT:-21600}
barman_conf=${BARMAN_CONF:-/etc/barman.conf}

if [ -f "$status_file" ]
then
    cur_ts=$(date +%s)
    read ts st desc <<<$(sed 's/\;/\ /g' "$status_file")

    ts_delta=$(( $cur_ts - $ts ))
    if [ "$ts_delta" -gt "$crit_limit" ]
    then
        die 2 "Check is stale for $(printf '%dh %dm %ds\n' $(($ts_delta/3600)) $(($ts_delta%3600/60)) $(($ts_delta%60))). Last: $desc"
    elif [ "$st" = "2" ]
    then
        die 2 "$desc"
    elif [ "$ts_delta" -gt "$warn_limit" ]
    then
        die 1 "Check is stale for $(printf '%dh %dm %ds\n' $(($ts_delta/3600)) $(($ts_delta%3600/60)) $(($ts_delta%60))). Last: $desc"
    elif [ "$st" = "0" ]
    then
        die 0 "OK"
    else
        die "$st" "$desc"
    fi
else
    if [ -f "$barman_conf" ]
    then
        die 1 "$status_file not found"
    else
        die 0 "OK"
    fi
fi
