#!/bin/bash

FILE=$1
PERMISSIONS=$2
OWNER=$3

if [ -f "$FILE" ]; then
    [[ $(stat -c '%U:%G' "$FILE") == "$OWNER" ]] || { echo "2;file $FILE owner and group do not match $OWNER"; exit 0; }
    [[ $(stat -c '%a' "$FILE") -ge "$PERMISSIONS" ]] || { echo "2;file $FILE permissions are less than $PERMISSIONS"; exit 0; }
    echo "0;OK"
else
    echo "0;file $FILE does not exist"
fi
