die() {
    echo "$1;$2"
    exit 0
}

if [ -f /usr/local/sbin/autodetect_environment ] ; then
    is_virtual_host=0
    . /usr/local/sbin/autodetect_environment >/dev/null 2>&1 || true
    if [ "$is_virtual_host" -eq 1 ] ; then
        die 0 "OK"
    fi
fi

if grep 'model name' /proc/cpuinfo | grep -q 'KVM'
then
    die 0 "OK"
elif grep -q 'Booting paravirtualized kernel on KVM' /var/log/dmesg 2>/dev/null
then
    die 0 "OK"
fi

if [ -f /var/tmp/last_raid_check ]
then
    last_raid_check=$(</var/tmp/last_raid_check)
    if [ $(($last_raid_check + 31 * 86400)) -gt $(date +%s) ]
           then
               die 0 "OK"
           else
               die 1 "last raid check was $(( ($(date +%s) - ${last_raid_check}) / 86400 )) day(s) ago"
        fi
else
   die 0 "OK"
fi
