#!/usr/bin/env python

import psycopg2
import sys

def die(code=0, comment="OK"):
    print('%d;%s' % (code, comment))
    sys.exit(0)


def get_archive_command():
    try:
        conn = psycopg2.connect('dbname=postgres user=monitor connect_timeout=1')
        cur = conn.cursor()
        cur.execute("SELECT setting FROM pg_settings WHERE name='archive_command';")
        archive_command = cur.fetchone()[0]
        return archive_command
    except psycopg2.OperationalError:
        die(1, "Could not connect to postgres")
    except Exception:
        die(1, "Could not get archive_command")
    finally:
        try:
            cur.close()
            conn.close()
        except Exception:
            pass

if __name__ == '__main__':
    archive_command = get_archive_command()
    if 'wal-g' in archive_command:
        die()
    else:
        die(code=2, comment='%s' % archive_command)
