{% from "components/postgres/pg.jinja" import pg with context %}
#!/bin/bash

die () {
    echo "$1;$2"
    exit 0
}

while getopts "r:w:c:n:e:j:" OPTION
do
    case $OPTION in
        n)
            WATCH_SECONDS="$OPTARG"
        ;;
        r)
            REGEX="$OPTARG"
        ;;
        e)
            EXCLUDE="$OPTARG"
        ;;
        j)
            JUNK_LINES="$OPTARG"
        ;;
    esac
done

watch_seconds=${WATCH_SECONDS:-600}
junk_lines=${JUNK_LINES:-1000000000}
regex=${REGEX:-'([0-9]{4}-[0-9]{2}-[0-9]{2}\ [0-9]{2}\:[0-9]{2}\:[0-9]{2}.[0-9]{3}\ MSK)'}

logfile="{{ pg.log_file_path }}"

xx00_count=$(sudo -u postgres timetail -j "$junk_lines" -n "$watch_seconds" -r "$regex" "$logfile" 2>&1 | fgrep XX00 | fgrep -c 'ERROR:')

if [ "$xx00_count" -gt "0" ]
then
    die 2 "Possible data corruption: $xx00_count XX00 errors for last $watch_seconds seconds."
else
    die 0 OK
fi
