#!/usr/bin/env python

import argparse
import sys

import psycopg2

parser = argparse.ArgumentParser()

parser.add_argument('-w', '--warn',
                    type=long,
                    default=10000,
                    help='Warning limit')

parser.add_argument('-c', '--crit',
                    type=long,
                    default=100000,
                    help='Critical limit')

parser.add_argument('-d', '--dbname',
                    type=str,
                    default="postgres",
                    help='Database to check')

parser.add_argument('-s', '--schema',
                    type=str,
                    default="public",
                    help='Table schema')

parser.add_argument('-t', '--table',
                    type=str,
                    help='Table name')

args = parser.parse_args()

def die(code=0, comment="OK"):
    if code == 0:
        print("0;OK")
    else:
        print('%d;%s' % (code, comment))
    sys.exit(0)

try:
    if not args.table:
        die(0, "OK")

    conn = psycopg2.connect("dbname=%s user=monitor connect_timeout=1" % args.dbname)
    cur = conn.cursor()

    cur.execute("SHOW transaction_read_only;")
    if 'on' in str(cur.fetchone()[0]):
        die(0, "OK")

    cur.execute("""
        SELECT n_live_tup FROM pg_stat_user_tables
            WHERE schemaname = %(schema)s AND relname = %(table)s
    """, {'schema': args.schema, 'table': args.table})

    if cur.rowcount < 1:
        die(1, "Couldn't find relation %s.%s" % (args.schema, args.table))
    ntuples = cur.fetchone()[0]
    if ntuples > args.crit:
        die(2, "%s.%s queue has %d rows" % (args.schema, args.table, ntuples))
    elif ntuples > args.warn:
        die(1, "%s.%s queue has %d rows" % (args.schema, args.table, ntuples))
    else:
        die(0, "OK")

except Exception as e:
    die(1, "Could not get info about queue: %s" % e)
