#!/usr/bin/env python
import sys

import psycopg2


def die(code=0, comment="OK"):
    print('%d;%s' % (code, comment))
    sys.exit(0)


try:
    conn = psycopg2.connect('dbname=postgres user=monitor connect_timeout=1')
    cur = conn.cursor()

    cur.execute("show transaction_read_only;")

    if 'off' in str(cur.fetchone()[0]):
        die(2, "unacceptable dc {{ salt['grains.get']('ya:short_dc') }}")
except Exception:
    die(1, "unable to detect master")
finally:
    try:
        cur.close()
        conn.close()
    except Exception:
        pass
die(0, "OK")
