#!/usr/bin/env python3

import subprocess
import sys

import psycopg2


def die(code=0, comment="OK"):
    print('%d;%s' % (code, comment))
    sys.exit(0)


def get_pillar(pillar_name):
    try:
        return subprocess.check_output(
            ['sudo', '/usr/bin/salt-call', 'pillar.get', pillar_name],
            stderr=subprocess.STDOUT,
            timeout=10
        )
    except Exception:
        return None


try:
    if len(sys.argv) < 2:
        die(comment="DB not specified")
    dbname = sys.argv[1]
    conn = psycopg2.connect('dbname=%s user=monitor connect_timeout=1' % dbname)
    cur = conn.cursor()
    cur.execute("SELECT max(version) FROM public.schema_version")
    db_version = cur.fetchone()
    if not db_version:
        die(comment="DB %s not versioned" % dbname)
    db_version = db_version[0]
    for i in range(3):
        salt_output = get_pillar('data:%s:target' % dbname)
        if salt_output:
            break
    else:
        raise Exception('pillar get failed')
    salt_version_str = salt_output.split()[-1]
    try:
        salt_version = int(salt_version_str)
    except ValueError:
        die(comment="DB %s not versioned" % dbname)
    else:
        if db_version < salt_version:
            die(
                code=2,
                comment="%s < %s, there are %s missed migrations" % (
                    db_version, salt_version, salt_version - db_version
                ),
            )
except Exception as e:
    die(1, "check failed %s" % e)
finally:
    try:
        cur.close()
        conn.close()
    except Exception:
        pass

die()
