#!/usr/bin/env python

import sys

import psycopg2


def die(code=0, comment="OK"):
    print('%d;%s' % (code, comment))
    sys.exit(0)


sync_code, async_code = {% if salt['pillar.get']('data:pgsync:change_replication_type', 'yes') == 'yes' %}0, 2{% else %}2, 0{% endif %}

try:
    conn = psycopg2.connect('dbname=postgres user=monitor connect_timeout=1')
    cur = conn.cursor()
    cur.execute("SELECT pg_is_in_recovery();")
    is_replica = cur.fetchone()
    if is_replica and is_replica[0]:
        die(comment="Not master")

    cur.execute("show synchronous_standby_names;")
    sync_replicas = [row[0].replace('_', '.') for row in cur.fetchall()]
    if sync_replicas and sync_replicas[0]:
        die(code=sync_code, comment="Sync replicas: " + ",".join(sync_replicas))
    die(code=async_code, comment="Cluster is in async mode")
except Exception as e:
    die(1, "Could not get replication info")
finally:
    try:
        cur.close()
        conn.close()
    except Exception:
        pass
