#!/usr/bin/env python

import psycopg2
import sys
import argparse

parser = argparse.ArgumentParser()

parser.add_argument('-c', '--crit',
                    type=float,
                    default=float(1),
                    help='Critical limit')

args = parser.parse_args()

def die(code=0, comment="OK"):
    if not comment:
        comment = 'OK'
    print '%d;%s' % (code, comment)
    sys.exit(0)

try:
    conn = psycopg2.connect('dbname=postgres user=monitor connect_timeout=1')
    cur = conn.cursor()

    cur.execute("SELECT pg_is_in_recovery();")
    is_replica = cur.fetchone()
    if is_replica and is_replica[0]:
        die(comment="Not master")
    else:
        die_code = 0
        message = ''
        deadPrc = {}

        cur.execute("SELECT datname FROM pg_database WHERE " +
                    "datistemplate = false AND datname != 'postgres';")
        dbnames = cur.fetchall()
        cur.close()
        conn.close()

        for dbname in dbnames:
            conn = psycopg2.connect('user=monitor connect_timeout=1 ' +
                                    'dbname=%s' % dbname[0])
            cur = conn.cursor()
            cur.execute("SELECT psut.relname, " +
                        "CASE WHEN pg_class.reltuples > 0 THEN CAST(psut.n_dead_tup AS real)*100/pg_class.reltuples " +
                        "ELSE 0 END " +
                        "AS percent_of_dead_tuples " +
                        "FROM pg_stat_user_tables psut JOIN pg_class ON psut.relid = pg_class.oid " +
                        "WHERE n_dead_tup > 300000 " +
                        "ORDER BY percent_of_dead_tuples DESC;")

            result = cur.fetchall()
            for i in result:
                name = dbname[0] + '.' + i[0]
                deadPrc[name] = i[1]
            cur.close()
            conn.close()

        for table, prc in deadPrc.items():
            if prc >= args.crit:
                message += '{0} {1:.2f}%; '.format(table, prc)
                die_code = 2

        die(die_code, message)

except Exception as e:
    die(2, "Could not get info about dead tuples" + repr(e))
