#!/usr/bin/env python

import sys
import argparse
import subprocess
import json
import time

parser = argparse.ArgumentParser()

parser.add_argument('-s', '--status',
                    type=int,
                    default=60,
                    help='Warning time limit (seconds) for last status-update')

parser.add_argument('-f', '--failover',
                    type=int,
                    default=3600,
                    help='Warning time limit (seconds) for last failover')

args = parser.parse_args()

def die(code=0, comment="OK"):
    if code == 0:
        print '0;OK'
    else:
        print('%d;%s' % (code, comment))
    sys.exit(0)

try:
    devnull = open('/dev/null', 'w')
    res = subprocess.call('ls /etc/init.d/pgsync', shell=True, \
                          stdout=devnull, stderr=devnull)
    if res != 0: # No pgsync installed
        die(2, 'Pgsync is not installed')

    res = subprocess.call('sudo service pgsync status', shell=True, \
                          stdout=devnull, stderr=devnull)
    if res != 0:
        die(2, 'Pgsync is not running.')

    status_file = open('/tmp/pgsync.status', 'r')
    status = json.load(status_file)

    if status['ts'] + args.status <= time.time():
        die(2, 'Last update of status file was %d seconds ago.' % \
                int(time.time() - status['ts']))

    if status['zk_state'].get('lock_holder') is None:
        die(2, 'No one holds leader lock in ZK.')

    last = status['zk_state'].get('last_failover_time')
    if last and last + args.failover >= time.time():
        die(1, 'Last failover has been done %d seconds ago.' % \
                int(time.time() - last))

    zk_tli = status['zk_state'].get('timeline')
    db_tli = status['db_state'].get('timeline')
    if db_tli and zk_tli and db_tli != zk_tli:
        die(1, 'Timeline of PostgreSQL (%d) is not equal to ' % db_tli +
               'timeline in ZK (%d).' % zk_tli)
except Exception as err:
    die(1, str(err))
finally:
    try:
        devnull.close()
    except Exception:
        pass

die()
