#!/bin/sh

crit_flag=0
warn_flag=0
message=""

die () {
        echo "$1;$2"
        exit 0
}

SHARPEI_HOST=$1
if [ -z $SHARPEI_HOST ]; then
    die 0 "No sharpei"
fi

no_reg () {
    REG_WEIGHT=$(curl -s --connect-timeout 1 --max-time 10 $SHARPEI_HOST/stat_with_weight 2>/dev/null | jq '.[] | select(.databases[].address.host == "'$HOSTNAME'") | .reg_weight')
    [[ "$REG_WEIGHT" -ne 0 ]] && return 1 || return 0
}

if no_reg; then
    die 0 "No registration"
fi

warn_limit=60
crit_limit=70
cmd="sudo df"
out=$($cmd -P -l -k -t ext2 -t ext3 -t ext4 -t xfs -t simfs | grep postgresql)
for i in $(echo "$out" | awk '{print $NF};')
do
    used_space=$(echo "$out" | grep " $i\$" | awk '{print $5};' | sed 's/%//g')
    if [ "$used_space" -ge "$crit_limit" ]
    then
        crit_flag=1
        message="$message$used_space% used on $i. "
    elif [ "$used_space" -ge "$warn_limit" ]
    then
        warn_flag=1
        message="$message$used_space% used on $i. "
    fi
done

if [ $crit_flag -ne 0 ]; then die 2 "$message"; fi
if [ $warn_flag -ne 0 ]; then die 1 "$message"; fi
die 0 "OK"
