#!/bin/bash

while getopts "w:c:n:" OPTION
do
    case $OPTION in
        w)
            WARN_LIMIT="$OPTARG"
        ;;
        c)
            CRIT_LIMIT="$OPTARG"
        ;;
        n)
            WATCH_SECONDS="$OPTARG"
        ;;
    esac
done

warn_limit=${WARN_LIMIT:-100}
crit_limit=${CRIT_LIMIT:-1000}
watch_seconds=${WATCH_SECONDS:-300}

count=0

for f in /var/log/postgresql/pgbouncer*.log
do
    count="$(( $count + $(timetail -n "${watch_seconds}" -r '([0-9]{4}-[0-9]{2}-[0-9]{2}\ [0-9]{2}\:[0-9]{2}\:[0-9]{2})' "${f}" | grep -v FIXME | grep -c -E '(ERROR|WARNING)') ))"
done

if [ "$count" -gt "$crit_limit" ]
then
    echo "2;$count"
elif [ "$count" -gt "$warn_limit" ]
then
    echo "1;$count"
else
    echo "0;OK"
fi
