#!/usr/bin/env python

import os
import sys
import time

import requests


def die(status=0, msg='OK'):
    print('%d;%s' % (status, msg))
    sys.exit(0)


if os.path.exists('/tmp/pgaas_proxy.close'):
    die(1, 'Close file exists')
else:
    tries = 0
    while tries < 3:
        try:
            res = requests.get('http://localhost:8081/monitor/ping',
                               timeout=1).text
            break
        except Exception as exc:
            res = repr(exc)
            time.sleep(1)
            tries += 1

    if res == 'OK':
        if os.path.exists('/tmp/pgaas_proxy.dummy'):
            die(1, 'Dummy file exists')
        else:
            die()
    else:
        die(2, res)
