#!/usr/bin/env python

import argparse

import requests


def _main():
    try:
        parser = argparse.ArgumentParser()
        parser.add_argument(
            '-r',
            '--ro_limit',
            type=int,
            default=10,
            help='Turn on crit if this many shards are read-only',
        )
        args = parser.parse_args()

        res = requests.get('http://localhost:8081/stat').json()
        msg = []
        ret = 0

        data = {'total': 0, 'ro': 0, 'dead': 0}

        for i in res:
            if 'total_clusters' in i[0]:
                data['total'] = int(i[1])
            if 'ro_clusters' in i[0]:
                data['ro'] = int(i[1])
            elif 'dead_hosts' in i[0]:
                data['dead'] = int(i[1])

        if data['ro'] > 0:
            msg.append('%s shards are read-only' % data['ro'])
            ret = 1
            if data['ro'] > args.ro_limit/100.0 * data['total']:
                ret = 2

        if data['dead'] > 0:
            ret = max(ret, 1)
            msg.append('%s hosts are dead' % data['dead'])
        if msg:
            print('%d;%s' % (ret, ', '.join(msg)))
        else:
            print('0;OK')
    except Exception as exc:
        print('1;%s' % exc)


if __name__ == '__main__':
    _main()
