#!/usr/bin/env python
"""
Check if local redis sentinel knows alive master
"""

import sys

from redis.sentinel import MasterNotFoundError, Sentinel

PORT = {{ salt['pillar.get']('data:sentinel:config:port', 26379) }}
MASTER_NAME = '{{ salt['pillar.get']('data:dbaas:cluster_name', salt['pillar.get']('data:redis:sentinel_config:master_name', 'mymaster')) }}'


def die(status=0, message='OK'):
    """
    Print status in monrun-compatible format
    """
    print('{status};{message}'.format(status=status, message=message))
    sys.exit(0)


def _main():
    try:
        conn = Sentinel([('127.0.0.1', PORT), ('::1', PORT)])
        conn.discover_master(MASTER_NAME)
        die()
    except MasterNotFoundError:
        die(2, 'No master in cluster')
    except Exception:
        pass
    die(2, 'Local sentinel is dead')


if __name__ == '__main__':
    _main()
