#!/usr/bin/env python
"""
Check if local redis responds to ping
"""

import sys

from redis import StrictRedis

PASSWORD = '{{ salt['pillar.get']('data:redis:secrets:password') }}'
PORT = {{ salt['pillar.get']('data:redis:config:port', 6379) }}


def die(status=0, message='OK'):
    """
    Print status in monrun-compatible format
    """
    print('{status};{message}'.format(status=status, message=message))
    sys.exit(0)


def _main():
    for address in ['127.0.0.1', '::1']:
        try:
            conn = StrictRedis(
                host=address, port=PORT, db=0, password=PASSWORD)
            if conn.ping():
                die()
        except Exception:
            pass
    die(2, 'Local redis is dead')


if __name__ == '__main__':
    _main()
