#!/bin/bash

die () {
    echo "$1;$2"
    exit 0
}

DEFAULT_LOG_FILE=/var/log/nginx/access-tskv.log

while getopts "g:w:c:s:l:r:f:" OPTION
do
    case $OPTION in
        w)
            WARN_LIMIT="$OPTARG"
        ;;
        g)
            GREP_STRING="$OPTARG"
        ;;
        c)
            CRIT_LIMIT="$OPTARG"
        ;;
        s)
            WATCH_SECONDS="$OPTARG"
        ;;
        l)
            LOG_FILE="$OPTARG"
        ;;
        f)
            FILTER="$OPTARG"
        ;;
    esac
done

warn_limit=${WARN_LIMIT:-150}
crit_limit=${CRIT_LIMIT:-700}
watch_seconds=${WATCH_SECONDS:-600}
log_file=${LOG_FILE:-$DEFAULT_LOG_FILE}
grep_string=${GREP_STRING:-'status=5'}
filter=${FILTER:-cat}

if ! which timetail >/dev/null 2>&1
then
    die 1 "timetail not found"
fi

if [ -f "${log_file}" ]; then
    count=$(timetail -t tskv -n "$watch_seconds" "$log_file" | $filter | grep -c "$grep_string")

    if [ "$count" -gt "$crit_limit" ]; then
        die 2 "$count $grep_string for last $watch_seconds seconds"
    elif [ "$count" -gt "$warn_limit" ]; then
        die 1 "$count $grep_string for last $watch_seconds seconds"
    else
        die 0 "OK"
    fi
else
    die 2 "File $log_file not found"
fi
