#!/bin/bash

die () {
    echo "$1;$2"
    exit 0
}

DEFAULT_LOG_FILE=/var/log/nginx/access-tskv.log

while getopts "g:w:c:s:l:r:" OPTION
do
    case $OPTION in
        w)
            WARN_LIMIT="$OPTARG"
        ;;
        g)
            GREP_STRING="$OPTARG"
        ;;
        c)
            CRIT_LIMIT="$OPTARG"
        ;;
        s)
            WATCH_SECONDS="$OPTARG"
        ;;
        l)
            LOG_FILE="$OPTARG"
        ;;
    esac
done

warn_limit=${WARN_LIMIT:-5}
crit_limit=${CRIT_LIMIT:-0}
watch_seconds=${WATCH_SECONDS:-60}
log_file=${LOG_FILE:-$DEFAULT_LOG_FILE}
grep_string=${GREP_STRING:-'status=2'}

rotation_check () {
    if [ -f "$log_file-$(date +%Y%m%d).gz" ]
    then
        delta=$(( $(date +%s) - $(stat -c '%Z' "$log_file-$(date +%Y%m%d).gz" 2>/dev/null) ))
        if [ "$delta" -lt "$watch_seconds" ]
        then
            die 0 "Log rotated recently"
        fi
    fi
}

if ! which timetail >/dev/null 2>&1
then
    die 1 "timetail not found"
fi

if [ -f "${log_file}" ]; then
    count=$(timetail -t tskv -n "$watch_seconds" "$log_file" | grep -c "$grep_string" )
    
    if [ "$count" -lt "$crit_limit" ]; then
        rotation_check
        die 2 "$count $grep_string for last $watch_seconds seconds"
    elif [ "$count" -lt "$warn_limit" ]; then
        rotation_check
        die 1 "$count $grep_string for last $watch_seconds seconds"
    else
        die 0 "OK"
    fi
else
    die 2 "File $log_file not found"
fi
