#!/usr/bin/env python

import requests
from requests.adapters import HTTPAdapter
import sys

TIMEOUT = 1.0

def get_code(url):
    ses = requests.Session()
    # http://docs.python-requests.org/en/master/api/#requests.adapters.HTTPAdapter
    ses.mount(
        'http://',
        HTTPAdapter(
            max_retries=1,
            pool_connections=1,
            pool_maxsize=1,
        )
    )
    try:
        result = ses.get(url, timeout=TIMEOUT)
        return result.status_code
    except requests.ConnectionError:
        raise Exception('unable to connect')
    except requests.Timeout:
        raise Exception('read timed out (%s)' % TIMEOUT)

def result(code=0, msg='OK'):
    print(
        '{c};{m}'.format(
            c=code,
            m=msg
        )
    )
    sys.exit(0)

try:
    code = get_code('http://localhost/pingdb')
    actions = {
        200: [0, 'OK'],
        # 410 Gone -- https://tools.ietf.org/html/rfc2616#section-10.4.11
        410: [1, 'closed'],
    }
    result(*actions.get(
        code, [2, 'err: got %s' % code]
    ))
except Exception as exc:
    result(2, 'exc: %s' % exc)
