#!/usr/bin/env python
import sys

import requests


def die(status=0, message='OK'):
    print "%s;%s" % (status, message)
    sys.exit(0)


def with_retry(url, retries=3, timeout=3):
    for i in range(retries):
        try:
            result = requests.get(url, timeout=timeout)
            if result.status_code != 200:
                raise ValueError('bad code')
            return result
        except Exception:
            pass
    else:
        die(1, 'Can not get %s' % url)


def get_conductor_hosts(*groups):
    hosts = set()
    for group in groups:
        group_hosts = with_retry('https://c.yandex-team.ru/api/groups2hosts/%s' % group).text.split()
        for host in group_hosts:
            hosts.add(host.strip())
    return hosts


def get_sharpei_hosts():
    hosts = set()
    stat = with_retry('http://localhost/stat').json()
    for shard in stat.values():
        for db in shard['databases']:
            hosts.add(db['address']['host'])
    return hosts


if __name__ == '__main__':
    groups = sys.argv[1:]
    if not groups:
        die(1, 'No groups to monitor')
    conductor_hosts = get_conductor_hosts(*groups)
    sharpei_hosts = get_sharpei_hosts()
    missed_hosts = conductor_hosts - sharpei_hosts
    if missed_hosts:
        die(2, 'Missed: ' + ','.join(missed_hosts))
    extra_hosts = sharpei_hosts - conductor_hosts
    if extra_hosts:
        die(2, 'Extra: ' + ','.join(extra_hosts))
    die()
