#!/usr/bin/python
# -*- coding: UTF-8 -*-
#
# Provides: push-client


import subprocess, sys, time, re, socket, os
import time
import datetime

def result(status,info):
    print "PASSIVE-CHECK:push-client;" + str(status) + ";" + info;
    exit()

prog=""

#Выясняем путь исполняемого файла push-client:
try:
    f = open('/etc/init.d/statbox-push-client', 'r')
    for line in f:
        if re.search("^DAEMON_BIN=",line):
            prog = line.split('"')[1]
    f.close()
except:
    result(2, "Can't find /etc/init.d/statbox-push-client")

if prog == "":
    result(2, "Can't parse /etc/init.d/statbox-push-client")


#Проверяем запущен ли push-clinet:
if os.system('pidof '+prog+'>/dev/null'):
    result(2, "push-client stoped")

#Получаем список yamil-конфигов:
CONFIG = []
try:
    f = open('/etc/default/push-client', 'r')
    for line in f:
        if re.search("^DAEMON_CONF=",line):
            line = line.split('"')[1]
            for cfg in line.split(" "):
                if re.search("yaml",cfg):
                    CONFIG.append(cfg)
    f.close()
except:
    CONFIG.append('/etc/push-client/push-client.yaml')


for cfg in CONFIG:
    conf_name = re.sub(".*/","",cfg)
    #Получаем информацию о количестве отправленных строк и времени с момента последней отправки:
    str_log = 'push-client -c ' + cfg + ' --status'
    p = subprocess.Popen(str_log.split(), stderr=subprocess.PIPE)
    out,strings = p.communicate()

    LOG = []
    log_err_msg="Can't read info for"
    for line in strings.splitlines():
        if re.search(log_err_msg,line):
            log = line.split("'")[2]
            now = datetime.datetime.now()
            #Ночью вместо критикала показываем ворнинг, если проблема с логом
            if now.hour > 2:
                result(2, log_err_msg + ": " + log)
            else:
                result(1, log_err_msg + ": " + log)
        #Лог-файл:
        if re.search("'",line):
            log = line.split("'")[1]
        #Количество отправленных строк:
        if re.search("lines read",line):
            lines = int(line.split(": ")[2])
        #Время последней отправки:
        if re.search("last_send_time",line):
            send_time = re.sub(".*last_send_time: ","",line).split()[0]
            send = int(time.time()) - int(send_time)
            LOG.append((log, lines,send))

    for item in LOG:
        if item[1] == 0:
            result(1, conf_name + ": " + item[0] + ": read 0 lines")
        if item[2] > 600:
            result(2, conf_name + ": " + item[0] + " Send delay: " + str(item[2]) + "sec")

result(0,"OK")
