#!/usr/bin/perl
#
# Provides: mops_dbpool mops_oracle_ro mops_pg_errors

my $mops_dbpool_errors=0;
my $mops_oracle_ro_errors=0;
my $mops_pg_errors=0;

if (-e "/var/log/mops/mops.log") {

open (MAILLOG, "/usr/bin/timetail -n 60 -r ':([0-9][0-9]:[0-9][0-9]:[0-9][0-9])' /var/log/mops/mops.log |");

while ($line=<MAILLOG>) {
	if($line =~ m/can't get db connection from pool/) {
		$mops_dbpool_errors++;
	}elsif($line =~ m/(ORA-16000|ORA-20103)/) {
		$mops_oracle_ro_errors++;
	}elsif($line =~ m/can't call request/) {
		$mops_pg_errors++;
	}
}

close MAILLOG;
}
if($mops_dbpool_errors < 10){
	print "PASSIVE-CHECK:mops_dbpool;0;DBpool errors: $mops_dbpool_errors\n";
}else{
	print "PASSIVE-CHECK:mops_dbpool;2;DBpool errors: $mops_dbpool_errors\n";
}

if($mops_oracle_ro_errors < 10){
	print "PASSIVE-CHECK:mops_oracle_ro;0;Oracle RO errors: $mops_oracle_ro_errors\n";
}else{
	print "PASSIVE-CHECK:mops_oracle_ro;2;Oracle RO errors: $mops_oracle_ro_errors\n";
}

if($mops_pg_errors < 5){
        print "PASSIVE-CHECK:mops_pg_errors;0;PG errors: $mops_pg_errors\n";
}else{
        print "PASSIVE-CHECK:mops_pg_errors;2;PG errors: $mops_pg_errors\n";
}
