#!/usr/bin/perl
#
# Provides: sanitizer_http_4xx sanitizer_http_5xx 

my $sanitizer_http_4xx=0;
my $sanitizer_http_5xx=0;

if (-e "/var/log/nginx/sanitizer/access.log") {

open (SANLOG, "timetail -n300 /var/log/nginx/sanitizer/access.log |");

while ($line=<SANLOG>) {
	if($line =~ m/HTTP\/1\.\d" (\d+) "/) {
		if($1 >= 400 && $1 < 499) {
                        $sanitizer_http_4xx++;
                } 
		elsif($1 >= 500) {
                                $sanitizer_http_5xx++;
		}
	}
}

close SANLOG;
}
if($sanitizer_http_4xx < 200){
	print "PASSIVE-CHECK:sanitizer_http_4xx;0;OK: sanitizer_http_4xx=$sanitizer_http_4xx\n";
}else{
	print "PASSIVE-CHECK:sanitizer_http_4xx;2;Critical: sanitizer_http_4xx=$sanitizer_http_4xx\n";
}

if($sanitizer_http_5xx < 200){
        print "PASSIVE-CHECK:sanitizer_http_5xx;0;OK: sanitizer_http_5xx=$sanitizer_http_5xx\n";
}else{
        print "PASSIVE-CHECK:sanitizer_http_5xx;2;Critical: sanitizer_http_5xx=$sanitizer_http_5xx\n";
}
