#!/usr/bin/perl
#
# Provides: http_5xx neo2_http_4xx neo2_http_5xx api_http_4xx api_http_5xx disk_http_4xx disk_http_5xx lite_http_4xx lite_http_5xx abook_http_4xx abook_http_5xx touch_http_4xx touch_http_5xx api_mobile_4xx api_mobile_5xx wy_http_4xx wy_http_5xx liza_4xx liza_5xx handlers fatal_errors js_errors do_login feedback_errors

my $http_total=0;

my $http_5xx=0;

my $neo2_http_4xx=0;
my $neo2_http_5xx=0;

my $api_http_4xx=0;
my $api_http_5xx=0;

my $api_mobile_4xx=0;
my $api_mobile_5xx=0;

my $disk_http_4xx=0;
my $disk_http_5xx=0;

my $lite_http_4xx=0;
my $lite_http_5xx=0;

my $abook_http_4xx=0;
my $abook_http_5xx=0;

my $touch_http_4xx=0;
my $touch_http_5xx=0;

my $api_mobile_4xx=0;
my $api_mobile_5xx=0;

my $wy_http_4xx=0;
my $wy_http_5xx=0;

my $liza_4xx=0;
my $liza_5xx=0;

my $handlers_errors=0;
my $feedback_errors=0;
my $fatal_errors=0;
my $js_errors=0;
my $do_login=0;

my @handlers;
my $top_handlers;

my $excvalue=undef;

if (-e "/etc/yamail/blackurl") {
	open (EXC, '<', "/etc/yamail/blackurl");
	while (my $excline=<EXC>) {
		chomp($excline);
		$excvalue = $excvalue . '|' . $excline ;
	}
        $excvalue = substr $excvalue, 1;
	$excvalue = qr/$excvalue/;
        close EXC;
}

if (-e "/var/log/nginx/mail/access.log") {

open (MAILLOG, "timetail -n60 /var/log/nginx/mail/access.log |");

while ($line=<MAILLOG>) {
	if($line =~ m/HTTP\/1\.\d" (\d+) "/) {
		$http_total++;
		if($1 >= 400 && $1 < 499) {
			if($line =~ m/ \/wy\//) {
                                $wy_http_4xx++;
                        }
                        if($line =~ m/ \/api\//) {
				if($line =~ m/ \/api\/mobile\//) {
					$api_mobile_4xx++;
				}
				else {
	                                $api_http_4xx++;
				}
                        } elsif($line =~ m/_h=disk/) {
                                $disk_http_4xx++;
                        } elsif($line =~ m/ \/lite\//) {
				if($line !~ m/444/) {
                                	$lite_http_4xx++;
				}
                        } elsif($line =~ m/_h=abook/) {
                                $abook_http_4xx++;
                        } elsif($line =~ m/ \/neo2\//) {
                                $neo2_http_4xx++;
                        } elsif($line =~ m/ \/touch\//) {
				$touch_http_4xx++;
			} elsif($line =~ m/ \/u2709\/api\/models/) {
                                $liza_4xx++;
                        }
		} elsif($1 >= 500 && ($line !~ /$excvalue/ || !defined($excvalue))) {
			$http_5xx++;
			if($line =~ m/ \/wy\//) {
				$wy_http_5xx++;
			}
                        if($line =~ m/ \/api\//) {
				if($line =~ m/ \/api\/mobile\//) {
                                        $api_mobile_5xx++;
                                }
                                else {
                                        $api_http_5xx++;
				}
                        } elsif($line =~ m/_h=disk/) {
                                $disk_http_5xx++;
                        } elsif($line =~ m/ \/lite\//) {
				if($line !~ m/503/) {
                                	$lite_http_5xx++;
				}
                        } elsif($line =~ m/_h=abook/) {
                                $abook_http_5xx++;
                        } elsif($line =~ m/ \/neo2\// && ($line !~ /$excvalue/ || !defined($excvalue))) {
                                $neo2_http_5xx++;
                        } elsif($line =~ m/ \/touch\//) {
				$touch_http_5xx++;
			} elsif($line =~ m/ \/u2709\/api\/models/) {
				$liza_5xx++;
			}
		}
	}
    if($line =~ m/(GET|POST) \/monitoring\.txt\?/) {
        if($line =~ m/errorType=HandlerError\&name=([A-Za-z\-]+)/ && $line !~ m/informer-weather|phone-unconfirmed|staff-get-user-info/) {
            $handlers_errors++;
	    push(@handlers,"$1 ");
	    if($line =~ m/\&name=feedback-help-/) {
		$feedback_errors++;
		}
        } elsif($line =~ m/errorType=FatalError/) {
            $fatal_errors++;
        } elsif($line =~ m/errorType=(JSError|exception\.action|exception\.events|yate\.run)/) {
	    $js_errors++;
	} elsif($line =~ m/event=doLogin/) {
	    $do_login++;	
	}
    }
}

close MAILLOG;
}
	print "PASSIVE-CHECK:http_5xx;0;$http_5xx\n";

if (@handlers) {
	my %counts_handlers;
	$counts_handlers{$_}++ for @handlers;
	my @sorted_handlers = reverse sort {$counts_handlers{$a} cmp $counts_handlers{$b}} keys %counts_handlers;
	$top_handlers=$sorted_handlers[0];
	chomp $top_handlers;
}

if($neo2_http_4xx < 120){
	print "PASSIVE-CHECK:neo2_http_4xx;0;OK: neo2_http_4xx=$neo2_http_4xx\n";
}else{
	print "PASSIVE-CHECK:neo2_http_4xx;2;Critical: neo2_http_4xx=$neo2_http_4xx\n";
}

if($api_http_4xx < 10){
	print "PASSIVE-CHECK:api_http_4xx;0;OK: api_http_4xx=$api_http_4xx\n";
}else{
	print "PASSIVE-CHECK:api_http_4xx;2;Critical: api_http_4xx=$api_http_4xx\n";
}

if($api_mobile_4xx < 50){
        print "PASSIVE-CHECK:api_mobile_4xx;0;OK: api_mobile_4xx=$api_mobile_4xx\n";
}else{
        print "PASSIVE-CHECK:api_mobile_4xx;2;Critical: api_mobile_4xx=$api_mobile_4xx\n";
}

if($disk_http_4xx < 10){
	print "PASSIVE-CHECK:disk_http_4xx;0;OK: disk_http_4xx=$disk_http_4xx\n";
}else{
	print "PASSIVE-CHECK:disk_http_4xx;2;Critical: disk_http_4xx=$disk_http_4xx\n";
}

if($lite_http_4xx < 10){
	print "PASSIVE-CHECK:lite_http_4xx;0;OK: lite_http_4xx=$lite_http_4xx\n";
}else{
	print "PASSIVE-CHECK:lite_http_4xx;2;Critical: lite_http_4xx=$lite_http_4xx\n";
}

if($abook_http_4xx < 30){
	print "PASSIVE-CHECK:abook_http_4xx;0;OK: abook_http_4xx=$abook_http_4xx\n";
}else{
	print "PASSIVE-CHECK:abook_http_4xx;2;Critical: abook_http_4xx=$abook_http_4xx\n";
}

if($touch_http_4xx < 10){
        print "PASSIVE-CHECK:touch_http_4xx;0;OK: touch_http_4xx=$touch_http_4xx\n";
}else{
        print "PASSIVE-CHECK:touch_http_4xx;2;Critical: touch_http_4xx=$touch_http_4xx\n";
}

if($liza_4xx < 5){
        print "PASSIVE-CHECK:liza_4xx;0;OK: liza_4xx=$liza_4xx\n";
}else{
        print "PASSIVE-CHECK:liza_4xx;2;Critical: liza_4xx=$liza_4xx\n";
}

if($wy_http_4xx < 10){
        print "PASSIVE-CHECK:wy_http_4xx;0;OK: wy_http_4xx=$wy_http_4xx\n";
}else{
        print "PASSIVE-CHECK:wy_http_4xx;2;Critical: wy_http_4xx=$wy_http_4xx\n";
}

if($neo2_http_5xx < 100){
	print "PASSIVE-CHECK:neo2_http_5xx;0;OK: neo2_http_5xx=$neo2_http_5xx\n";
}else{
	print "PASSIVE-CHECK:neo2_http_5xx;2;Critical: neo2_http_5xx=$neo2_http_5xx\n";
}

if($api_http_5xx < 10){
	print "PASSIVE-CHECK:api_http_5xx;0;OK: api_http_5xx=$api_http_5xx\n";
}else{
	print "PASSIVE-CHECK:api_http_5xx;2;Critical: api_http_5xx=$api_http_5xx\n";
}

if($api_mobile_5xx < 30){
        print "PASSIVE-CHECK:api_mobile_5xx;0;OK: api_mobile_5xx=$api_mobile_5xx\n";
}else{
        print "PASSIVE-CHECK:api_mobile_5xx;2;Critical: api_mobile_5xx=$api_mobile_5xx\n";
}

if($disk_http_5xx < 10){
	print "PASSIVE-CHECK:disk_http_5xx;0;OK: disk_http_5xx=$disk_http_5xx\n";
}else{
	print "PASSIVE-CHECK:disk_http_5xx;2;Critical: disk_http_5xx=$disk_http_5xx\n";
}

if($lite_http_5xx < 10){
	print "PASSIVE-CHECK:lite_http_5xx;0;OK: lite_http_5xx=$lite_http_5xx\n";
}else{
	print "PASSIVE-CHECK:lite_http_5xx;2;Critical: lite_http_5xx=$lite_http_5xx\n";
}

if($abook_http_5xx < 30){
	print "PASSIVE-CHECK:abook_http_5xx;0;OK: abook_http_5xx=$abook_http_5xx\n";
}else{
	print "PASSIVE-CHECK:abook_http_5xx;2;Critical: abook_http_5xx=$abook_http_5xx\n";
}

if($touch_http_5xx < 10){
        print "PASSIVE-CHECK:touch_http_5xx;0;OK: touch_http_5xx=$touch_http_5xx\n";
}else{
        print "PASSIVE-CHECK:touch_http_5xx;2;Critical: touch_http_5xx=$touch_http_5xx\n";
}

if($wy_http_5xx < 5){
        print "PASSIVE-CHECK:wy_http_5xx;0;OK: wy_http_5xx=$wy_http_5xx\n";
}else{
        print "PASSIVE-CHECK:wy_http_5xx;2;Critical: wy_http_5xx=$wy_http_5xx\n";
}

if($liza_5xx < 3){
        print "PASSIVE-CHECK:liza_5xx;0;OK: liza_5xx=$liza_5xx\n";
}else{
        print "PASSIVE-CHECK:liza_5xx;2;Critical: liza_5xx=$liza_5xx\n";
}

if($handlers_errors < 40){
	print "PASSIVE-CHECK:handlers;0;OK: handlers=$handlers_errors\n";
}else{
	print "PASSIVE-CHECK:handlers;2;Critical: handlers=$handlers_errors top=$top_handlers\n";
}

print "PASSIVE-CHECK:fatal_errors;0;fatal=$fatal_errors total=$http_total\n";

if($feedback_errors < 2){
        print "PASSIVE-CHECK:feedback_errors;0;OK: feedback_errors=$feedback_errors\n";
}else{
        print "PASSIVE-CHECK:feedback_errors;2;Critical: feedback_errors=$feedback_errors\n";
}

if($js_errors < 30){
        print "PASSIVE-CHECK:js_errors;0;OK: js_errors=$js_errors\n";
}else{
        print "PASSIVE-CHECK:js_errors;2;Critical: js_errors=$js_errors\n";
}

if($do_login < 15){
        print "PASSIVE-CHECK:do_login;0;OK: do_login=$do_login\n";
}else{
        print "PASSIVE-CHECK:do_login;2;Critical: do_login=$do_login\n";
}
