#!/usr/bin/perl
#
# Provides: sum_errors dbpool oracle_ro blackbox_rr blackbox_slb blackbox_oauth_rr blackbox_oauth_slb sms_errors remind_errors notify_errors wmi_timeouts sophos_errors sharpei_errors pg_errors fastsrv_errors nwsmtp_errors

my $sum_errors=0;
my $dbpool_errors=0;
my $blackbox_rr_errors=0;
my $blackbox_slb_errors=0;
my $blackbox_oauth_rr_errors=0;
my $blackbox_oauth_slb_errors=0;
my $oracle_ro_errors=0;
my $sms_errors=0;
my $remind_errors=0;
my $notify_errors=0;
my $wmi_timeouts=0;
my $sophos_errors=0;
my $sharpei_errors=0;
my $pg_errors=0;
my $fastsrv_errors=0;
my $nwsmtp_errors=0;

my @timeouts;
my $top_timeouts;

if (-e "/var/log/wmi/wmi.log") {

open (MAILLOG, "/usr/bin/timetail -n 60 -r ':([0-9][0-9]:[0-9][0-9]:[0-9][0-9])' /var/log/wmi/wmi.log |");

while ($line=<MAILLOG>) {
	if($line !~ m/status=info/) {
		$sum_errors++;	
	}
	if($line =~ m/can't get db connection from pool/) {
		$dbpool_errors++;
	}elsif($line =~ m/(ORA-16000|ORA-20103)/) {
		$oracle_ro_errors++;
	}elsif($line =~ m/blackbox try=(\d) /) {
		if($1 == 0) {
			if($line =~ m/oauth/) {
				$blackbox_oauth_rr_errors++;
			} else {
				$blackbox_rr_errors++;
			}
		} elsif($1 == 1) {
			if($line =~ m/oauth/) {
                                $blackbox_oauth_slb_errors++;
                        } else {
			$blackbox_slb_errors++;
			}
		}
	}elsif($line =~ m/sms_message_part/) {
		$sms_errors++;
	}elsif($line =~ m/no_answer_remind status=error/) {
		$remind_errors++;
	}elsif($line =~ m/no_answer_notify status=error/) {
                $notify_errors++;
	}elsif($line =~ m/Exceeded limit of retries to fastsrv/) {
                $fastsrv_errors++;
        }
        if($line =~ m/embedded_http host=(.*):\d+ status=error/) {
		push(@timeouts,"$1 ");	
		$wmi_timeouts++;
	}	
	if($line =~ m/icap virus check failed/) {
		$sophos_errors++;
	}
	if($line =~ m/error while resolving uid by sharpei|sharpei_client error: bad http code/) {
                $sharpei_errors++;
        }
	if($line =~ m/database error/ && $line =~ m/:pg/) {
		if($line =~ m/sharpei_client/) {
                	$sharpei_errors++;
		} else {
			$pg_errors++;
		}
        }
	if($line =~ m/error when sending to smtp server.*tries limit reached/ && $line =~ m/status=error host=mxbacks/) 
	{
		$nwsmtp_errors++;	
	}
}
close MAILLOG;
}

if (-e "/var/log/hound/wmi.log") {

open (HOUNDLOG, "/usr/bin/timetail -n 60 -r ':([0-9][0-9]:[0-9][0-9]:[0-9][0-9])' /var/log/hound/wmi.log |");

while ($line=<HOUNDLOG>) {
        if($line !~ m/status=info/) {
                $sum_errors++;
        }
        if($line =~ m/can't get db connection from pool/) {
                $dbpool_errors++;
        }elsif($line =~ m/(ORA-16000|ORA-20103)/) {
                $oracle_ro_errors++;
        }elsif($line =~ m/blackbox try=(\d) /) {
                if($1 == 0) {
                        if($line =~ m/oauth/) {
                                $blackbox_oauth_rr_errors++;
                        } else {
                                $blackbox_rr_errors++;
                        }
                } elsif($1 == 1) {
                        if($line =~ m/oauth/) {
                                $blackbox_oauth_slb_errors++;
                        } else {
                        $blackbox_slb_errors++;
                        }
                }
        }elsif($line =~ m/sms_message_part/) {
                $sms_errors++;
        }elsif($line =~ m/no_answer_remind status=error/) {
                $remind_errors++;
        }elsif($line =~ m/no_answer_notify status=error/) {
                $notify_errors++;
        }
        if($line =~ m/embedded_http host=(.*):\d+ status=error/) {
                push(@timeouts,"$1 ");
                $wmi_timeouts++;
        }
        if($line =~ m/icap virus check failed/) {
                $sophos_errors++;
        }
        if($line =~ m/error while resolving uid by sharpei/) {
                $sharpei_errors++;
        }
        if($line =~ m/database error/ && $line =~ m/:pg/) {
	         $pg_errors++;
        }
    }
close HOUNDLOG;
}
if (@timeouts) {
	my %counts_timeouts;
	$counts_timeouts{$_}++ for @timeouts;
	my @sorted_timeouts = reverse sort {$counts_timeouts{$a} cmp $counts_timeouts{$b}} keys %counts_timeouts;
	$top_timeouts=$sorted_timeouts[0];
	chomp $top_timeouts;
}

if($sum_errors < 750000){
	print "PASSIVE-CHECK:sum_errors;0;Summary errors: $sum_errors\n";
}else{
	print "PASSIVE-CHECK:sum_errors;2;Summary errors: $sum_errors\n";
}

if($dbpool_errors < 100){
	print "PASSIVE-CHECK:dbpool;0;DBpool errors: $dbpool_errors\n";
}else{
	print "PASSIVE-CHECK:dbpool;2;DBpool errors: $dbpool_errors\n";
}

if($wmi_timeouts < 500){
        print "PASSIVE-CHECK:wmi_timeouts;0;WMI timeouts: $wmi_timeouts\n";
}else{
        print "PASSIVE-CHECK:wmi_timeouts;2;WMI timeouts: $wmi_timeouts top=$top_timeouts\n";
}

if($oracle_ro_errors < 10){
	print "PASSIVE-CHECK:oracle_ro;0;Oracle RO errors: $oracle_ro_errors\n";
}else{
	print "PASSIVE-CHECK:oracle_ro;2;Oracle RO errors: $oracle_ro_errors\n";
}

if($blackbox_rr_errors < 100){
	print "PASSIVE-CHECK:blackbox_rr;0;Blackbox rr errors: $blackbox_rr_errors\n";
}else{
	print "PASSIVE-CHECK:blackbox_rr;2;Blackbox rr errors: $blackbox_rr_errors\n";
}

if($blackbox_slb_errors < 100){
	print "PASSIVE-CHECK:blackbox_slb;0;Blackbox slb errors: $blackbox_slb_errors\n";
}else{
	print "PASSIVE-CHECK:blackbox_slb;2;Blackbox slb errors: $blackbox_slb_errors\n";
}

if($blackbox_oauth_rr_errors < 100){
        print "PASSIVE-CHECK:blackbox_oauth_rr;0;Blackbox oauth rr errors: $blackbox_oauth_rr_errors\n";
}else{
        print "PASSIVE-CHECK:blackbox_oauth_rr;2;Blackbox oauth rr errors: $blackbox_oauth_rr_errors\n";
}

if($blackbox_oauth_slb_errors < 100){
        print "PASSIVE-CHECK:blackbox_oauth_slb;0;Blackbox oauth slb errors: $blackbox_oauth_slb_errors\n";
}else{
        print "PASSIVE-CHECK:blackbox_oauth_slb;2;Blackbox oauth slb errors: $blackbox_oauth_slb_errors\n";
}

if($sms_errors < 10){
        print "PASSIVE-CHECK:sms_errors;0;SMS errors: $sms_errors\n";
}else{
        print "PASSIVE-CHECK:sms_errors;2;SMS errors: $sms_errors\n";
}

if($notify_errors < 3){
        print "PASSIVE-CHECK:notify_errors;0;Notifier errors: $notify_errors\n";
}else{
        print "PASSIVE-CHECK:notify_errors;2;Notifier errors: $notify_errors\n";
}

if($remind_errors < 3){
        print "PASSIVE-CHECK:remind_errors;0;Reminder errors: $remind_errors\n";
}else{
        print "PASSIVE-CHECK:remind_errors;2;Reminder errors: $remind_errors\n";
}

if($sophos_errors < 5){
        print "PASSIVE-CHECK:sophos_errors;0;Sophos errors: $sophos_errors\n";
}else{
        print "PASSIVE-CHECK:sophos_errors;2;Sophos errors: $sophos_errors\n";
}

if($sharpei_errors < 5){
        print "PASSIVE-CHECK:sharpei_errors;0;Sharpei errors: $sharpei_errors\n";
}else{
        print "PASSIVE-CHECK:sharpei_errors;2;Sharpei errors: $sharpei_errors\n";
}

if($pg_errors < 5){
        print "PASSIVE-CHECK:pg_errors;0;PG errors: $pg_errors\n";
}else{
        print "PASSIVE-CHECK:pg_errors;2;PG errors: $pg_errors\n";
}

if($fastsrv_errors < 5){
        print "PASSIVE-CHECK:fastsrv_errors;0;fastsrv errors: $fastsrv_errors\n";
}else{
        print "PASSIVE-CHECK:fastsrv_errors;2;fastsrv errors: $fastsrv_errors\n";
}

if($nwsmtp_errors < 1){
        print "PASSIVE-CHECK:nwsmtp_errors;0;nwsmtp errors: $nwsmtp_errors\n";
}else{
        print "PASSIVE-CHECK:nwsmtp_errors;2;nwsmtp errors: $nwsmtp_errors\n";
}
