#!/usr/bin/env python3

import socket
import xml.etree.ElementTree as etree
import re

HOST = 'localhost'
PORT = 31091

# read from socket
s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
data = bytes()
s.connect((HOST, PORT))
while True:
    chunk = s.recv(4096)
    if not chunk:
        break
    data += chunk

# pull out lags from gathered data
xmlroot = etree.fromstring(data.decode("utf-8"))
lags = {}
if xmlroot.findall('./modules/equalizer/'):
    for node in xmlroot.findall('./modules/equalizer/'):
        lags[node.find('name').text] = int(node.find('lag').text)

proddb = ("mdb100",
          "mdb150",
          "mdb200",
          "mdb302",
          "mdb303",
          "mdb304",
          "mdb305")
critlag = 180
warnlag = 60

prodsatadb = ("mdb1010",
              "mdb1020",
              "mdb2020",
              "mdb3010",
              "mdb3020")
critsatalag = 600
warnsatalag = 180

resdict = {'CRIT': {},
           'WARN': {},
           'OK'  : {}}
for db, lag in lags.items():
    # regular bases in production
    if (db not in prodsatadb):
        if (lag > critlag):
            resdict['CRIT'][db] = lag
        elif (lag > warnlag):
            resdict['WARN'][db] = lag
        else:
            resdict[ 'OK' ][db] = lag
    # slow sata bases in production
    elif (db in prodsatadb):
        if (lag > critsatalag):
            resdict['CRIT'][db] = lag
        elif (lag > warnsatalag):
            resdict['WARN'][db] = lag
        else:
            resdict[ 'OK' ][db] = lag
    # all other bases
    else:
        if (lag > warnlag):
            resdict['WARN'][db] = lag
        else:
            resdict[ 'OK' ][db] = lag

# generate decent check description
checkdesc = ''
checkstatus = 0
if resdict['OK']:
    checkstatus = 0
    tmpdesc = 'OK: '
    for (db, lag) in resdict['OK'].items():
        tmpdesc += 'lag_{}={} '.format(db, lag)
    checkdesc = tmpdesc + checkdesc
if resdict['WARN']:
    checkstatus = 1
    tmpdesc = 'WARN: '
    for (db, lag) in resdict['WARN'].items():
        tmpdesc += 'lag_{}={} '.format(db, lag)
    checkdesc = tmpdesc + checkdesc
if resdict['CRIT']:
    checkstatus = 2
    tmpdesc = 'CRIT: '
    for (db, lag) in resdict['CRIT'].items():
        tmpdesc += 'lag_{}={} '.format(db, lag)
    checkdesc = tmpdesc + checkdesc
print('{};{}'.format(checkstatus, checkdesc))

