#!/usr/bin/env python3

# for reading settings from equalizer configs requires pyyaml
import http.client as http
import json
import eq_db_monitor_settings as settings

# request all acquired dbs
acquired_dbs = set([])
for equalizer in settings.equalizers_list:
  try:
    conn = http.HTTPConnection(equalizer, 31080, timeout=10)
    conn.request("GET","/state")
    resp = conn.getresponse()
    if resp.status == 200:
      body = resp.read().decode('UTF-8')
      if not body.startswith('"empty"'):
        db_list_ext = json.loads(body)
        acquired_dbs |= set([ key for key in db_list_ext ])
  except:
    pass

# request all known dbs: sharpei + ora_dbs
all_known_db_list = set(settings.ora_db_list)
try:
  conn = http.HTTPConnection(settings.sharpei_host, 80, timeout=10)
  conn.request("GET","/v2/stat")
  resp = conn.getresponse()
  if resp.status == 200:
    body = resp.read().decode('UTF-8')
    db_list_ext = json.loads(body)
    all_known_db_list |= set([ 'xdb'+key for key in db_list_ext ])
except:
  pass

missing_dbs = all_known_db_list.symmetric_difference(acquired_dbs) # or just difference enough?
if missing_dbs:
  print('2;{} not acquired!'.format(' '.join(missing_dbs)))
else:
  print('0;OK! all dbs acquired')
