#! /usr/bin/perl
#
# Provides: hub_nginx_4xx hub_nginx_5xx

use strict;
use warnings;

our %CONF = (
    '/var/log/nginx/xivahub/access.log' => [ '', 'nginx_front' ],
);

my $hostname = `hostname -f`;
chomp $hostname;
$hostname =~ y/\./_/;
my $prefix = '';

if ($hostname =~ m/xivahub\d+\w_mail_yandex_net/) {
    $prefix='mail.mail_xivahub';
} elsif ($hostname =~ m/xivahubcorp\d+\w_mail_yandex_net/) {
    $prefix='mail.mail_xivahubcorp';
} elsif ($hostname =~ m/xivahub-tst\d+\w_c?mail_yandex_net/) {
    $prefix='mail.mail_xivahub_tst';
} elsif ($hostname =~ m/xivahub-qa\d+\w_c?mail_yandex_net/) {
    $prefix='mail.mail_xivahub_qa';
} else {
    $prefix='mail.mail_xivahub_var';
}

for my $filename (keys %CONF) {
    my ($params, $name) = @{$CONF{$filename}};

    my $ts = time;

    my @codestotal = (0, 0, 0, 0, 0);
    my @codesnotify = (0, 0, 0, 0, 0);
    my @codessubscribe = (0, 0, 0, 0, 0);
    my @codesunsubscribe = (0, 0, 0, 0, 0);
    my $timing = 0;
    my %metrics;

    my $logtail;
    open ($logtail, "/usr/bin/timetail -n 60 $params $filename |");
    while (<$logtail>) {
        # match on http code 
        if ($_ =~ m/" (\d)\d\d "/) {
            $codestotal[$1-1]++;
        }
        if ($_ =~ m/ \/notify.*" (\d)\d\d "/) {
            my $code = $1;
            if ($_ !~ m/ \/notify\/disk-json.*?" (499|5)/) {
                $codesnotify[$code-1]++;
            }
            if ($_ =~ m/db=([\w\d]+)/) {
                $metrics{"$prefix.$hostname.$name.notify.by_channel.mail.all.received"}++;
                $metrics{"$prefix.$hostname.$name.notify.by_channel.mail.all.${code}xx"}++;
                $metrics{"$prefix.$hostname.$name.notify.by_channel.mail.by_db.$1.received"}++;
                $metrics{"$prefix.$hostname.$name.notify.by_channel.mail.by_db.$1.${code}xx"}++;
            }
        }
        if ($_ =~ m/ \/subscribe.*" (\d)\d\d "/) {
            $codessubscribe[$1-1]++;
        }
        if ($_ =~ m/ \/unsubscribe.*" (\d)\d\d "/) {
            $codesunsubscribe[$1-1]++;
        }
    }

    for (my $i = 4; $i <= scalar(@codestotal); ++$i) {
        if ($codesnotify[$i - 1] > 100) {
            print "PASSIVE-CHECK:hub_nginx_${i}xx;2;".$codesnotify[$i - 1]." errs\n";
        } elsif ($codesnotify[$i - 1] > 10) {
            print "PASSIVE-CHECK:hub_nginx_${i}xx;1;".$codesnotify[$i - 1]." errs\n";
        } else {
            print "PASSIVE-CHECK:hub_nginx_${i}xx;0;".$codesnotify[$i - 1]." errs\n";
        }
    }
}

