#!/usr/bin/perl
#
# Provides: hub_convey_fail hub_bb_error hub_xstore_fail hub_pq_fail hub_storage_fail hub_xtasks_fail hub_queue_overflow hub_no_master hub_convey_disabled
use warnings;

use Sys::Hostname;
use Try::Tiny;

(my $host = hostname) =~ s/\./_/g;
my $ts = time;

my $prefix;




if ($host =~ m/xivahub\d+\w_mail_yandex_net/) {
    $prefix = 'mail.mail_xivahub';
} elsif ($host =~ m/xivahubcorp\d+\w_mail_yandex_net/) {
    $prefix = 'mail.mail_xivahubcorp';
} elsif ($host =~ m/xivahub-tst\d+\w_c?mail_yandex_net/) {
    $prefix = 'mail.mail_xivahub_tst';
} elsif ($host =~ m/xivahub-qa\d+\w_c?mail_yandex_net/) {
    $prefix = 'mail.mail_xivahub_qa';
} else {
    $prefix = 'mail.mail_xivahub_var';
}

$prefix = "${prefix}.${host}";

my %metrics;

open (YXIVALOG, "timetail -n 60 -r '^\\[\\d{4}-\\w+-\\d{2} (\\d\\d:\\d\\d:\\d\\d\\.\\d{6})' /var/log/yxiva-hub/yxiva-hub.log |");

while ($line=<YXIVALOG>) {
    if ($line =~ m/task queue overflow/) {
        $metrics{"${prefix}.errors.queue_overflows"}++;
    }
    if ($line =~ m/blackbox temporary error/) {
        $metrics{"${prefix}.errors.blackbox"}++;
    }
    if ($line =~ m/storage fail/) {
        $metrics{"${prefix}.errors.storage"}++;
    }
    if ($line =~ m/ymod_pq fail/) {
        $metrics{"${prefix}.errors.postgre"}++;
    }
    if ($line =~ m/xtasks (\S+) (fail|error)/) {
        $metrics{"${prefix}.xivahub.xtasks.all.fail"}++;
    }
    if ($line =~ m/xtasks .*? no master/) {
        $metrics{"${prefix}.xivahub.xtasks.fail.no_master"}++;
    }
    if ($line =~ m/xstore (\S+) error/) {
        $metrics{"${prefix}.xivahub.xstore.all.fail"}++;
    }
    if ($line =~ m/failed: xstore/) {
        $metrics{"${prefix}.xivahub.xstore.all.fail"}++;
    }
    if ($line =~ m/filter apply exception/) {
        $metrics{"${prefix}.xivahub.filter.all.apply_exception"}++;
    }
    if ($line =~ m/notification status="new"/) {
        $metrics{"${prefix}.xivahub.notify.all.received"}++;
    }
    if ($line =~ m/notification status="saved"/) {
        $metrics{"${prefix}.xivahub.notify.all.saved"}++;
    }
    if ($line =~ m/notification status="save failed"/) {
        $metrics{"${prefix}.xivahub.notify.all.savefail"}++;
    }
    if ($line =~ m/notification status="job update failed"/) {
        $metrics{"${prefix}.xivahub.notify.all.job_update_fail"}++;
    }
    if ($line =~ m/notification status="conveyed"/) {
        $metrics{"${prefix}.xivahub.notify.all.success"}++;
        if ($line =~ m/service="(\w+)".*?subscription_id="(\w+):/) {
            $metrics{"${prefix}.xivahub.notify.by_service_scheme.${1}_${2}.success"}++;
        }
    }
    if (($line =~ m/notification status="convey failed"/) and ($line !~ m/client_id="mobile"/)) {
        $metrics{"${prefix}.xivahub.notify.all.fail"}++;
    }
    if ($line =~ m/notification status="convey disabled"/) {
        $metrics{"${prefix}.xivahub.notify.all.disabled"}++;
    }

}

my $hub_convey_fail_prc = 0;
my $hub_convey_disabled_prc = 0;
if (not($metrics{"${prefix}.xivahub.notify.all.fail"})) {
    $metrics{"${prefix}.xivahub.notify.all.fail"} = 0;
}
if (not($metrics{"${prefix}.xivahub.notify.all.disabled"})) {
    $metrics{"${prefix}.xivahub.notify.all.disabled"} = 0;
}
if (not($metrics{"${prefix}.xivahub.notify.all.received"})) {
    $metrics{"${prefix}.xivahub.notify.all.received"} = 0;
}
try {
    $hub_convey_fail_prc = $metrics{"${prefix}.xivahub.notify.all.fail"} * 100 / $metrics{"${prefix}.xivahub.notify.all.received"};
    $hub_convey_disabled_prc = $metrics{"${prefix}.xivahub.notify.all.disabled"} * 100 / $metrics{"${prefix}.xivahub.notify.all.received"};
} catch {
    #do nothing
};

if ($hub_convey_fail_prc > 5) {
        print sprintf("PASSIVE-CHECK:hub_convey_fail;2;%.2f%%\n", ${hub_convey_fail_prc});
} elsif ($hub_convey_fail_prc > 2) {
        print sprintf("PASSIVE-CHECK:hub_convey_fail;1;%.2f%%\n", ${hub_convey_fail_prc});
} else {
        print sprintf("PASSIVE-CHECK:hub_convey_fail;0;%.2f%%\n", ${hub_convey_fail_prc});
}

if ($hub_convey_disabled_prc > 5) {
        print sprintf("PASSIVE-CHECK:hub_convey_disabled;2;%.2f%%\n", ${hub_convey_disabled_prc});
} elsif ($hub_convey_disabled_prc > 2) {
        print sprintf("PASSIVE-CHECK:hub_convey_disabled;1;%.2f%%\n", ${hub_convey_disabled_prc});
} else {
        print sprintf("PASSIVE-CHECK:hub_convey_disabled;0;%.2f%%\n", ${hub_convey_disabled_prc});
}

$metrics{"${prefix}.errors.blackbox"} //= 0;
if ($metrics{"${prefix}.errors.blackbox"} > 30) {
        print "PASSIVE-CHECK:hub_bb_error;2;".${metrics{"${prefix}.errors.blackbox"}}." errs\n";
} elsif ($metrics{"${prefix}.errors.blackbox"} > 10) {
        print "PASSIVE-CHECK:hub_bb_error;1;".${metrics{"${prefix}.errors.blackbox"}}." errs\n";
} else {
        print "PASSIVE-CHECK:hub_bb_error;0;".${metrics{"${prefix}.errors.blackbox"}}." errs\n";
}

$metrics{"${prefix}.xivahub.xstore.all.fail"} //= 0;
if ($metrics{"${prefix}.xivahub.xstore.all.fail"} > 100) {
        print "PASSIVE-CHECK:hub_xstore_fail;2;".$metrics{"${prefix}.xivahub.xstore.all.fail"}." errs\n";
} elsif ($metrics{"${prefix}.xivahub.xstore.all.fail"} > 10) {
        print "PASSIVE-CHECK:hub_xstore_fail;1;".$metrics{"${prefix}.xivahub.xstore.all.fail"}." errs\n";
} else {
        print "PASSIVE-CHECK:hub_xstore_fail;0;".$metrics{"${prefix}.xivahub.xstore.all.fail"}." errs\n";
}

$metrics{"${prefix}.errors.postgre"} //= 0;
if ($metrics{"${prefix}.errors.postgre"} > 100) {
        print "PASSIVE-CHECK:hub_pq_fail;2;".$metrics{"${prefix}.errors.postgre"}." errs\n";
} elsif ($metrics{"${prefix}.errors.postgre"} > 10) {
        print "PASSIVE-CHECK:hub_pq_fail;1;".$metrics{"${prefix}.errors.postgre"}." errs\n";
} else {
        print "PASSIVE-CHECK:hub_pq_fail;0;".$metrics{"${prefix}.errors.postgre"}." errs\n";
}

$metrics{"${prefix}.errors.storage"} //= 0;
if ($metrics{"${prefix}.errors.storage"} > 100) {
        print "PASSIVE-CHECK:hub_storage_fail;2;".$metrics{"${prefix}.errors.storage"}." errs\n";
} elsif ($metrics{"${prefix}.errors.storage"} > 10) {
        print "PASSIVE-CHECK:hub_storage_fail;1;".$metrics{"${prefix}.errors.storage"}." errs\n";
} else {
        print "PASSIVE-CHECK:hub_storage_fail;0;".$metrics{"${prefix}.errors.storage"}." errs\n";
}

$metrics{"${prefix}.xivahub.xtasks.all.fail"} //= 0;
if ($metrics{"${prefix}.xivahub.xtasks.all.fail"} > 100) {
        print "PASSIVE-CHECK:hub_xtasks_fail;2;".$metrics{"${prefix}.xivahub.xtasks.all.fail"}." errs\n";
} elsif ($metrics{"${prefix}.xivahub.xtasks.all.fail"} > 10) {
        print "PASSIVE-CHECK:hub_xtasks_fail;1;".$metrics{"${prefix}.xivahub.xtasks.all.fail"}." errs\n";
} else {
        print "PASSIVE-CHECK:hub_xtasks_fail;0;".$metrics{"${prefix}.xivahub.xtasks.all.fail"}." errs\n";
}

$metrics{"${prefix}.errors.queue_overflows"} //= 0;
if ($metrics{"${prefix}.errors.queue_overflows"} > 100) {
        print "PASSIVE-CHECK:hub_queue_overflow;2;".$metrics{"${prefix}.errors.queue_overflows"}." errs\n";
} elsif ($metrics{"${prefix}.errors.queue_overflows"} > 10) {
        print "PASSIVE-CHECK:hub_queue_overflow;1;".$metrics{"${prefix}.errors.queue_overflows"}." errs\n";
} else {
        print "PASSIVE-CHECK:hub_queue_overflow;0;".$metrics{"${prefix}.errors.queue_overflows"}." errs\n";
}

$metrics{"${prefix}.xivahub.xtasks.fail.no_master"} //= 0;
if ($metrics{"${prefix}.xivahub.xtasks.fail.no_master"} > 100) {
        print "PASSIVE-CHECK:hub_no_master;2;".$metrics{"${prefix}.xivahub.xtasks.fail.no_master"}." errs\n";
} elsif ($metrics{"${prefix}.xivahub.xtasks.fail.no_master"} > 10) {
        print "PASSIVE-CHECK:hub_no_master;1;".$metrics{"${prefix}.xivahub.xtasks.fail.no_master"}." errs\n";
} else {
        print "PASSIVE-CHECK:hub_no_master;0;".$metrics{"${prefix}.xivahub.xtasks.fail.no_master"}." errs\n";
}

$metrics{"${prefix}.xivahub.notify.by_service_scheme.mail_mob.success"} //= 0;
if ($metrics{"${prefix}.xivahub.notify.by_service_scheme.mail_mob.success"} == 0) {
        print "PASSIVE-CHECK:hub_mail_mob_convey;2;".$metrics{"${prefix}.xivahub.notify.by_service_scheme.mail_mob.success"}." conveyed\n";
} else {
        print "PASSIVE-CHECK:hub_mail_mob_convey;0;".$metrics{"${prefix}.xivahub.notify.by_service_scheme.mail_mob.success"}." conveyed\n";
}
