#!/usr/bin/perl
#
# Provides: mesh_http_5xx mesh_http_4xx
use warnings;

use Sys::Hostname;
use Try::Tiny;

(my $host = hostname) =~ s/\./_/g;
my $ts = time;

my $prefix;




if ($host =~ m/xivamesh\d+\w_mail_yandex_net/) {
    $prefix = 'mail.mail_xivamesh';
} elsif ($host =~ m/xivameshcorp\d+\w_mail_yandex_net/) {
    $prefix = 'mail.mail_xivameshcorp';
} elsif ($host =~ m/xivamesh-tst\d+\w_c?mail_yandex_net/) {
    $prefix = 'mail.mail_xivamesh_tst';
} elsif ($host =~ m/xivamesh-qa\d+\w_c?mail_yandex_net/) {
    $prefix = 'mail.mail_xivamesh_qa';
} else {
    $prefix = 'mail.mail_xivamesh_var';
}

$prefix = "${prefix}.${host}";

my %metrics;

open (YXIVALOG, "timetail -n 60 /var/log/yxiva-mesh/access.log |");

while ($line=<YXIVALOG>) {
    if($line =~ m/HTTP\/1\.\d" (\d+) "/) {
        if($1 >= 500 && $1 < 600) {
            $metrics{"${prefix}.http.5xx"}++;
        } elsif($1 >=400 && $1 < 499) {
            $metrics{"${prefix}.http.4xx"}++;
        }
    }
}

$metrics{"${prefix}.http.5xx"} //= 0;
if ($metrics{"${prefix}.http.5xx"} > 50) {
        print "PASSIVE-CHECK:mesh_http_5xx;2;".${metrics{"${prefix}.http.5xx"}}." errs\n";
} elsif ($metrics{"${prefix}.http.5xx"} > 10) {
        print "PASSIVE-CHECK:mesh_http_5xx;1;".${metrics{"${prefix}.http.5xx"}}." errs\n";
} else {
        print "PASSIVE-CHECK:mesh_http_5xx;0;".${metrics{"${prefix}.http.5xx"}}." errs\n";
}

$metrics{"${prefix}.http.4xx"} //= 0;
if ($metrics{"${prefix}.http.4xx"} > 50) {
        print "PASSIVE-CHECK:mesh_http_4xx;2;".${metrics{"${prefix}.http.4xx"}}." errs\n";
} elsif ($metrics{"${prefix}.http.5xx"} > 10) {
        print "PASSIVE-CHECK:mesh_http_4xx;1;".${metrics{"${prefix}.http.4xx"}}." errs\n";
} else {
        print "PASSIVE-CHECK:mesh_http_4xx;0;".${metrics{"${prefix}.http.4xx"}}." errs\n";
}

