#!/usr/bin/perl
#
# Provides: xiva_oracle_ro xiva_oracle_disabled xiva_oracle_var_err xiva_invalid_http xiva_disk_unavail xiva_livemail_unavail xiva_calendar_unavail xiva_bb_error xiva_queue_overflow

use Sys::Hostname;
my $host = hostname;

my %mdb_ro; 		# hash of mdbs currently in RO state
my %mdb_disabled; 	# hash of mdbs currently disabled
my %mdb_var_err; 	# hash of mdbs suffering from various errors
my $disk_unavail = 0;
my $livemail_unavail = 0;
my $calendar_unavail = 0;
my $auth_error = 0;
my %invalid_http; 	# hash of bogus backends

open (XIVAERRORLOG, "timetail -n 60 -r '^\\[\\d{4}-\\w{3}-\\d{2} (\\d\\d:\\d\\d:\\d\\d\\.\\d{6})' /var/log/yxiva/yxiva.log |");

while ($line=<XIVAERRORLOG>) {
	if ($line =~ m/\bymod_occi_(mdb\d{2,})\b.*(\bORA-12514\b|\bORA-12170\b)/) {
		$mdb_disabled{$1} = 1;
	}elsif ($line =~ m/\bymod_occi_(mdb\d{2,})\b.*(\bORA-16000\b|\bORA-20103\b)/) {
		$mdb_ro{$1} = 1;
	}elsif ($line =~ m/\bymod_occi_(mdb\d{2,})\b.*(?!ORA-16000|ORA-20103|ORA-12514|ORA-12170)/) {
		$mdb_var_err{$1} = 1;
	}elsif ($line =~ m/yxiva_services can`t (un)?subscribe channel {(\w+),} reason: http response invalid/) {
		$invalid_http{$2};
	}elsif ($line =~ m/yxiva_services disk (un)?subscribe error.*reason: .* error/) {
		$disk_unavail++;
	}elsif ($line =~ m/yxiva_services livemail (un)?subscribe error.*reason: .* error/) {
		$livemail_unavail++;
	}elsif ($line =~ m/yxiva_services calendar (un)?subscribe error.*reason: .* error/) {
		$calendar_unavail++;
	}elsif ($line =~ m/queue overflow/) {
		$queue_overflow++;
	}elsif ($line =~ m/blackbox temporary error/) {
		$bb_error++;
	}elsif ($line =~ m/auth error/) {
		$auth_error++;
	}
}

if (%mdb_ro > 20) {
	my $mdb_string = join(", ", keys %mdb_ro);
	print "PASSIVE-CHECK:xiva_oracle_ro;2;Errors: $mdb_string\n";
}else{
	print "PASSIVE-CHECK:xiva_oracle_ro;0;OK!\n";
}

if (%mdb_disabled > 20) {
	my $mdb_string = join(", ", keys %mdb_disabled);
	print "PASSIVE-CHECK:xiva_oracle_disabled;2;Errors: $mdb_string\n";
}else{
	print "PASSIVE-CHECK:xiva_oracle_disabled;0;OK!\n";
}

if (%mdb_var_err > 20) {
	my $mdb_string = join(", ", keys %mdb_var_err);
	print "PASSIVE-CHECK:xiva_oracle_var_err;2;Errors: $mdb_string\n";
}else{
	print "PASSIVE-CHECK:xiva_oracle_var_err;0;OK!\n";
}

if (%invalid_http > 20) {
	my $backends_string = join(", ", keys %invalid_http);
	print "PASSIVE-CHECK:xiva_invalid_http;2;Errors: $backends_string\n";
}else{
	print "PASSIVE-CHECK:xiva_invalid_http;0;OK!\n";
}

if ($disk_unavail > 20) {
	print "PASSIVE-CHECK:xiva_disk_unavail;2;$disk_unavail times\n";
}else{
	print "PASSIVE-CHECK:xiva_disk_unavail;0;OK!\n";
}

if ($livemail_unavail > 20) {
	print "PASSIVE-CHECK:xiva_livemail_unavail;2;$livemail_unavail times\n";
}else{
	print "PASSIVE-CHECK:xiva_livemail_unavail;0;OK!\n";
}

if ($calendar_unavail > 10) {
	print "PASSIVE-CHECK:xiva_calendar_unavail;2;$calendar_unavail times\n";
}else{
	print "PASSIVE-CHECK:xiva_calendar_unavail;0;OK!\n";
}

if ($auth_error > 1200) {
	print "PASSIVE-CHECK:xiva_auth_error;2;$auth_error times\n";
} elsif ($auth_error > 500) {
	print "PASSIVE-CHECK:xiva_auth_error;1;$auth_error times\n";
} else {
	print "PASSIVE-CHECK:xiva_auth_error;0;$auth_error times\n";
}

if ($queue_overflow > 50) {
	print "PASSIVE-CHECK:xiva_queue_overflow;2;$queue_overflow times\n";
} elsif ($queue_overflow > 20) {
	print "PASSIVE-CHECK:xiva_queue_overflow;1;$queue_overflow times\n";
} else {
	print "PASSIVE-CHECK:xiva_queue_overflow;0;$queue_overflow times\n";
}

if ($bb_error > 50) {
	print "PASSIVE-CHECK:xiva_bb_error;2;$bb_error times\n";
} elsif ($bb_error > 20) {
	print "PASSIVE-CHECK:xiva_bb_error;1;$bb_error times\n";
} else {
	print "PASSIVE-CHECK:xiva_bb_error;0;$bb_error times\n";
}
# me=${0##*/}     # strip path
# me=${me%.*}     # strip extension
# LOG=/var/log/yxiva/error.log
# tailme=$BASE/bin/tailme

# die () {
#         echo "PASSIVE-CHECK:$me;$1;$2"
#         exit 0
# }

# if [ -f ${LOG} ]; then
#     databases=$($tailme $me $LOG | awk '/\Bymod_occi_(mdb\d+)\B.*(\BORA-12514\B|\BORA-12170\B)/ {print $0}')
#     if [ $count -gt 0 ]; then
#         die 2 "$databases"
#     else
#         die 0 "OK! No DB in RO state"
#     fi
# else
#     die 2 " File does not exist "
# fi
