{% set nginx_ver = salt['pillar.get']('data:nginx:version', '1.14.2-1.yandex.22') %}

nginx-package:
  pkg.installed:
    - pkgs:
      - nginx: {{ nginx_ver }}
      - lua-cjson: '2.1.0+dfsg-2'

nginx-service:
  service.running:
    - name: nginx
    - enable: True
    - require:
      - pkg: nginx-package

/etc/nginx/golovan-worker.lua:
  file.managed:
    - mode: 644
    - source: salt://{{ slspath }}/golovan-worker.lua
