#!/usr/bin/python

import os
from datetime import date, timedelta
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from smtplib import SMTP

import jinja2

REPORT_PATH = '/u0/backupcheck/status/'
TEMPLATE='/usr/local/share/backupcheck_template.jinja'
KEYS = ('shard', 'success', 'size', 'backup_fetch_t', 'pg_start_t', 'check_data_t', 'full_test_t')
RECIPIENT = 'disk-duty-alarm@yandex-team.ru'

def bytes_to_gigabytes(size):
    return int(size)/1024**3

def send_email(recipient, subject, html_data):
    msg = MIMEMultipart('alternative')
    msg['From'] = 'robot-disk-duty-adm@yandex-team.ru'
    msg['To'] = recipient
    msg['Subject'] = subject
    msg.attach(MIMEText(html_data, 'html', "utf-8"))
    server = SMTP('outbound-relay.yandex.net')
    server.sendmail(msg['From'], recipient, msg.as_string())

report_date = date.today() - timedelta(days=1)
formated_report_date = report_date.strftime('%Y-%m-%d')
filename = report_date.strftime('backupcheck-%Y-%m-%d.csv')
report = open(os.path.join(REPORT_PATH, filename), 'r')
results = [dict(zip(KEYS, items.strip().split(';'))) for items in report.readlines()]

for result in results:
    result['size'] = bytes_to_gigabytes(result['size'])
    result['success'] = 'SUCCESS' if result['success'] == 'True' else 'FAILED'
    for k in KEYS[3:]:
        result[k] = str(timedelta(seconds=round(float(result[k]))))

template = jinja2.Template(open(TEMPLATE, 'r').read())
rendered_data = template.render(date=formated_report_date, results=results)

subj = 'Postgres backup check report {}'.format(formated_report_date)
send_email(RECIPIENT, subj, rendered_data)
