include:
    - components.common.dirs

/var/lib/postgresql/.yav_oauth_token:
    file.managed:
        - contents: {{ salt['pillar.get']('data:yav:token', '') }}
        - template: jinja
        - user: postgres
        - group: postgres
        - mode: 400

/etc/cron.d/pg_db_list:
    file.managed:
        - template: jinja
        - source: salt://components/pg-backupcheck/conf/pg_db_list
        - user: root
        - group: root

/etc/logrotate.d/pg_backupcheck:
    file.managed:
        - source: salt://components/pg-backupcheck/conf/logrotate.d/pg_backupcheck
        - user: root
        - group: root

/usr/local/bin/pg_backupcheck.py:
    file.managed:
        - source: salt://components/pg-backupcheck/conf/pg_backupcheck.py
        - user: root
        - group: root
        - mode: 755

/usr/local/bin/pg_backupcheck_report.py:
    file.managed:
        - source: salt://components/pg-backupcheck/conf/pg_backupcheck_report.py
        - user: root
        - group: root
        - mode: 755

/usr/local/bin/shard_list.py:
    file.managed:
        - source: salt://components/pg-backupcheck/conf/shard_list.py
        - user: root
        - group: root
        - mode: 755

/usr/local/share/backupcheck_template.jinja:
    file.managed:
        - source: salt://components/pg-backupcheck/conf/backupcheck_template.jinja
        - user: root
        - group: root
        - mode: 644

/etc/init/backupcheck.conf:
    file.managed:
        - source: salt://components/pg-backupcheck/conf/backupcheck.conf
        - user: root
        - group: root
        - mode: 644

/etc/monrun/conf.d/pg_backupcheck_status.conf:
    file.managed:
        - source: salt://components/pg-backupcheck/conf/pg_backupcheck_status.conf
        - user: root
        - group: root
        - mode: 644

/etc/monrun/conf.d/pg_backupcheck_old.conf:
    file.managed:
        - source: salt://components/pg-backupcheck/conf/pg_backupcheck_old.conf
        - user: root
        - group: root
        - mode: 644

/usr/local/yandex/monitoring/backupcheck_status.sh:
    file.managed:
        - source: salt://components/pg-backupcheck/conf/backupcheck_status.sh
        - user: root
        - group: root
        - mode: 755

/usr/local/yandex/monitoring/old_backups.sh:
    file.managed:
        - source: salt://components/pg-backupcheck/conf/old_backups.sh
        - user: root
        - group: root
        - mode: 755

/u0/backupcheck/blacklist:
    file.managed:
        - source: salt://components/pg-backupcheck/conf/blacklist
        - user: postgres
        - group: postgres
        - mode: 644

/etc/cron.d/backupcheck_report:
    file.managed:
        - source: salt://components/pg-backupcheck/conf/cron.d/backupcheck_report
        - user: root
        - group: root

/var/log/pg_backupcheck.log:
    file.managed:
        - user: postgres
        - group: postgres
        - mode: 644

db_list:
    cmd.run:
        - name: /usr/local/bin/shard_list.py --s3-endpoint https://s3.mds.yandex.net --list-to-file /u0/backupcheck/db_list --alerts-to-file /u0/backupcheck/outdated_list --blacklist /u0/backupcheck/blacklist
        - runas: postgres
        - require:
            - file: /usr/local/bin/shard_list.py
            - file: /u0/backupcheck/blacklist
        - creates: /u0/backupcheck/db_list
