postgresql-service:
    cmd.wait:
        - name: /bin/true
        - unless: /bin/true

include:
    - components.postgres.pkgs

exclude:
    - id: yamail-graphite-client-postgres
    - id: yamail-pgswitch
    - id: zk-flock-config-postgres

{%
    set pkgs = {
        'rsync': '3.1.0-2ubuntu0.4',
        'xinetd': '1:2.3.15-3ubuntu1',
        'lsscsi': '0.27-2',
        'e2fsprogs': '1.42.9-3ubuntu1.3',
        'xfsprogs': '3.1.9ubuntu2.1',
        'yandex-passport-vault-client': '1.4.0',
        'python-paramiko': '1.16.0-yandex1',
        'postgresql-10': '10.10-103-yandex.44396.2fbecb6',
        'postgresql-10-replmon': '1.0.1-26',
        'libpq5': '10.10-103-yandex.44396.2fbecb6',
        'postgresql-10-dbg': '10.10-103-yandex.44396.2fbecb6',
        'postgresql-client-10': '10.10-103-yandex.44396.2fbecb6',
        'postgresql-10-kcache': '2.0.3-7130f1f',
        'postgresql-10-repack': '1.4.4-1.pgdg14.04+1+yandex0',
        'postgresql-9.6': '9.6.9-1yandex.41743.1545ca9',
        'postgresql-9.6-dbg': '9.6.9-1yandex.41743.1545ca9',
        'postgresql-9.6-kcache': '2.0.3-7130f1f',
        'postgresql-9.6-smlar': '1.0-6',
        'postgresql-client-9.6': '9.6.9-1yandex.41743.1545ca9',
        'postgresql-contrib-9.6': '9.6.9-1yandex.41743.1545ca9',
        'python-urllib3' : '1.7.1-1ubuntu4.1',
        'python-pip': '6.1.1-yandex1',
        'postgresql-10-amcheck': 'any',
        'postgresql-9.6-amcheck': 'any'
    }
%}

shelf_tool:
    pkg.removed

{% for package, version in pkgs.items() %}
{% if version == 'any' %}
{{ package }}:
    pkg.installed

{% else %}
{{ package }}:
    pkg.installed:
        - version: {{ version }}
        - ignore_epoch: True
{% if salt['grains.get']('os') == 'Ubuntu' %}
        - require:
            - cmd: yandex-postgresql-stable
{% endif %}

{% endif %}

{% endfor %}
