{% set walg_coroutines = 30 %}
{% set walg_threads = walg_coroutines + 1 %}

walg-packages:
    pkg.installed:
        - pkgs:
            - wal-g: {{ salt['pillar.get']('data:walg:version', '458-b055370') }}
            - daemontools
            - python3-dateutil

/u0/backupcheck/wal-g/envdir:
    file.directory:
        - mode: 0750
        - makedirs: True
        - user: postgres

/u0/backupcheck/wal-g/envdir/AWS_ACCESS_KEY_ID:
    file.managed:
        - user: postgres
        - mode: 640
        - contents_pillar: data:s3:access_key_id
        - require:
            - pkg: walg-packages
            - file: /u0/backupcheck/wal-g/envdir

/u0/backupcheck/wal-g/envdir/AWS_SECRET_ACCESS_KEY:
    file.managed:
        - user: postgres
        - mode: 640
        - contents_pillar: data:s3:access_secret_key
        - require:
            - pkg: walg-packages
            - file: /u0/backupcheck/wal-g/envdir

/u0/backupcheck/wal-g/envdir/WALG_DELTA_MAX_STEPS:
    file.managed:
        - user: postgres
        - mode: 640
        - contents: 10
        - require:
            - pkg: walg-packages
            - file: /u0/backupcheck/wal-g/envdir

/u0/backupcheck/wal-g/envdir/GOMAXPROCS:
    file.managed:
        - user: postgres
        - mode: 640
        - contents: {{ walg_threads | int }}
        - require:
            - pkg: walg-packages
            - file: /u0/backupcheck/wal-g/envdir

/u0/backupcheck/wal-g/envdir/WALG_DOWNLOAD_CONCURRENCY:
    file.managed:
        - user: postgres
        - mode: 640
        - contents: {{ walg_coroutines | int }}
        - require:
            - pkg: walg-packages
            - file: /u0/backupcheck/wal-g/envdir

/u0/backupcheck/wal-g/envdir/WALG_UPLOAD_CONCURRENCY:
    file.managed:
        - user: postgres
        - mode: 640
        - contents: {{ walg_coroutines | int }}
        - require:
            - pkg: walg-packages
            - file: /u0/backupcheck/wal-g/envdir

/u0/backupcheck/wal-g/envdir/WALG_COMPRESSION_METHOD:
    file.managed:
        - contents: {{ salt['pillar.get']('data:walg:compression_method', 'lz4') }}
        - user: postgres
        - mode: 640
        - require:
            - pkg: walg-packages
            - file: /u0/backupcheck/wal-g/envdir

/u0/backupcheck/wal-g/envdir/PGHOST:
    file.managed:
        - user: postgres
        - mode: 640
        - contents: '/var/run/postgresql'
        - require:
            - pkg: walg-packages
            - file: /u0/backupcheck/wal-g/envdir

/u0/backupcheck/wal-g/envdir/PATH:
    file.managed:
        - user: postgres
        - mode: 640
        - contents: '/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/usr/lib/postgresql/9.6/bin'
        - require:
            - pkg: walg-packages
            - file: /u0/backupcheck/wal-g/envdir

/u0/backupcheck/wal-g/envdir/AWS_ENDPOINT:
    file.managed:
        - user: postgres
        - mode: 640
        - contents: {{ salt['pillar.get']('data:s3:endpoint', 'https://s3.mds.yandex.net/').replace('https+path','https').replace('http+path','http') }}
        - require:
            - pkg: walg-packages
            - file: /u0/backupcheck/wal-g/envdir

/u0/backupcheck/wal-g/envdir/WALE_LOG_DESTINATION:
    file.managed:
        - user: postgres
        - mode: 640
        - contents: syslog
        - require:
            - pkg: walg-packages
            - file: /u0/backupcheck/wal-g/envdir

/u0/backupcheck/wal-g/envdir/WALE_S3_PREFIX:
    file.managed:
        - user: postgres
        - mode: 640
        - require:
            - pkg: walg-packages
            - file: /u0/backupcheck/wal-g/envdir

/u0/backupcheck/wal-g/envdir/WALE_GPG_KEY_ID:
    file.managed:
        - user: postgres
        - mode: 640
        - require:
            - pkg: walg-packages
            - file: /u0/backupcheck/wal-g/envdir

/u0/backupcheck/wal-g/envdir/AWS_S3_FORCE_PATH_STYLE:
    file.managed:
        - user: postgres
        - mode: 640
        - contents: |
            {{ (not salt['pillar.get']('data:s3:virtual_addressing_style', False)) | json }}
        - require:
            - pkg: walg-packages
            - file: /u0/backupcheck/wal-g/envdir

/u0/backupcheck/wal-g/PGP_KEY:
    file.managed:
        - user: postgres
        - mode: 640
        - require:
            - pkg: walg-packages
            - file: /u0/backupcheck/wal-g/envdir

/u0/backupcheck/wal-g/envdir/WALG_PGP_KEY_PATH:
    file.managed:
        - user: postgres
        - mode: 640
        - contents: '/etc/wal-g/PGP_KEY'
        - require:
            - pkg: walg-packages
            - file: /u0/backupcheck/wal-g/envdir
