#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
import logging
import subprocess
import traceback
import os
import shutil
from datetime import date

logging.basicConfig(
    level=logging.DEBUG,
    format='%(asctime)s [%(levelname)s] %(name)s:\t%(message)s')

log = logging.getLogger('main')

try:
    p = subprocess.Popen(['barman', 'diagnose'], stdout=subprocess.PIPE)
    diagnose = json.loads(p.communicate()[0])
    p.wait()

    for server in diagnose['servers']:
        d = diagnose['servers'][server]['backups']
        minWal = 'FFFFFFFFFFFFFFFFFFFFFFFF'
        for backup in d:
            ymd = backup.split('T')[0]
            year = int(ymd[:4])
            month = int(ymd[4:6])
            day = int(ymd[6:])
            if (date.today() - date(year, month, day)).days > 14:
                if d[backup]['status'] != 'DONE':
                    log.info('Removing ' + server + '/' + backup)
                    p = subprocess.Popen(['barman', 'delete',
                                          server, backup],
                                         stdout=subprocess.PIPE)
                    for line in p.communicate()[0].split('\n'):
                        log.info('barman: ' + line.rstrip())
                    p.wait()
            else:
                wal = d[backup]['begin_wal']
                if wal is not None and wal < minWal:
                    minWal = d[backup]['begin_wal']

        if minWal.startswith('FF'):
            log.error(server + ' seems to have no valid backups')
            continue

        minSeg = minWal[:16]

        walsDir = diagnose['servers'][server]['config']['wals_directory']
        for s in os.listdir(walsDir):
            if len(s) == 16 and s < minSeg and 'history' not in s:
                log.info('Removing ' + os.path.join(walsDir, s))
                shutil.rmtree(os.path.join(walsDir, s), ignore_errors=True)
except Exception:
    log.error('Unexpected exception:')
    for line in traceback.format_exc().split('\n'):
        log.error(line.rstrip())
