#!/usr/bin/env python
# encoding: utf-8

import os
import socket
import subprocess
import sys
import argparse
import re

parser = argparse.ArgumentParser()


parser.add_argument('-r', '--remote',
                    type=str,
                    help='remote host')

parser.add_argument('-d', '--destination',
                    type=str,
                    help='path to pgdata on remote host')

args = parser.parse_args()

shard_name = re.match('[a-z0-9-]+[0-9]+', args.remote).group(0)

def last_backup():
    cmd = "/usr/bin/barman list-backup %s | grep -v FAILED | sort | tail -n1 | cut -f2 -d ' '" % \
            shard_name
    p = subprocess.Popen(cmd, stdout=subprocess.PIPE,shell=True)
    return p.communicate()[0].replace('\n','')

def restore_backup():
    cmd = '/usr/bin/barman recover --remote-ssh-command "ssh -o ConnectTimeout=5 -o StrictHostKeyChecking=no postgres@%s" %s %s %s' % \
            (args.remote,shard_name,last_backup(),args.destination)
    res = subprocess.call(cmd,shell=True, stdout=sys.stdout, \
                    stderr=sys.stderr)

def check_remote_destination():
    cmd = 'ssh -o ConnectTimeout=5 -o StrictHostKeyChecking=no postgres@%s ls -1 %s | grep -v lost+found | wc -l' % \
            (args.remote, args.destination)
    p = subprocess.Popen(cmd, stdout=subprocess.PIPE,shell=True)
    return int(p.communicate()[0].replace('\n',''))

def main():
    if check_remote_destination()==0:
        restore_backup()

if __name__ == '__main__':
    main()
