#!/bin/bash

DATA_DIR="$(barman show-server "$BARMAN_SERVER" | awk -F': ' '/data_directory/ {print $NF}' | head -n1)"
CONNINFO="$(barman show-server "$BARMAN_SERVER" | awk -F': ' '/conninfo/ {print $NF}' | head -n1)"
SSH_COMMAND="$(barman show-server "$BARMAN_SERVER" | awk -F': ' '/ssh_command/ {print $NF}' | head -n1)"
POSTGRES_VERSION="$(barman show-server "$BARMAN_SERVER" | awk -F': ' '/server_txt_version/ {print $NF}' | head -n1)"

if [[ $POSTGRES_VERSION == 1* ]]; then
	SWITCH_COMMAND='SELECT pg_switch_wal();'
else
	SWITCH_COMMAND='SELECT pg_switch_xlog();'
fi

RO=$(psql -t -A "$CONNINFO" -c 'SHOW transaction_read_only;')
if [ "x$RO" == "xoff" ]; then
    psql "$CONNINFO" -c "$SWITCH_COMMAND"
else
    MASTER_HOST=$(${SSH_COMMAND} fgrep primary_conninfo "$DATA_DIR/recovery.conf" | grep -Eo 'host=[a-z0-9_\.-]*' | sed -e 's/^host=//')
    MASTER_CONNSTRING=$(echo "$CONNINFO" | sed -e "s/host=[a-z0-9_\.-]*/host=${MASTER_HOST}/")
    psql "${MASTER_CONNSTRING}" -c "$SWITCH_COMMAND"
fi
